/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.fx.security.acl.AclRegistry;
import com.gridnine.xtrip.common.restriction.resource.RestrictionResourcesRegistry;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclPrincipal;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.resource.AclPropertyRestrictionGroupType;
import com.gridnine.xtrip.common.security.acl.rule.AclAction;
import com.gridnine.xtrip.common.security.acl.rule.AclFieldRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestriction;
import com.gridnine.xtrip.common.security.acl.rule.AclPropertyRestrictionGroup;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.util.DebugUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class AclEditorHelper {
    public static final Comparator<AclPrincipal> principalComparator = new Comparator<AclPrincipal>(){

        @Override
        public int compare(AclPrincipal o1, AclPrincipal o2) {
            if (o1 instanceof AclGroup && o2 instanceof AclGroup) {
                if (o1.equals(AclHelper.all)) {
                    return o2.equals(AclHelper.all) ? 0 : -1;
                }
                if (o2.equals(AclHelper.all)) {
                    return o1.equals(AclHelper.all) ? 0 : 1;
                }
                if (o1.equals(AclHelper.administators)) {
                    return o2.equals(AclHelper.administators) ? 0 : -1;
                }
                if (o2.equals(AclHelper.administators)) {
                    return o1.equals(AclHelper.administators) ? 0 : 1;
                }
                return MiscUtil.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
            if (o1 instanceof AclGroup && o2 instanceof AclUser) {
                return -1;
            }
            if (o1 instanceof AclUser && o2 instanceof AclGroup) {
                return 1;
            }
            if (o1 instanceof AclUser && o2 instanceof AclUser) {
                if (o1.equals(AclHelper.system)) {
                    return o2.equals(AclHelper.system) ? 0 : -1;
                }
                if (o2.equals(AclHelper.system)) {
                    return o1.equals(AclHelper.system) ? 0 : 1;
                }
                if (o1.equals(AclHelper.admin)) {
                    return o2.equals(AclHelper.admin) ? 0 : -1;
                }
                if (o2.equals(AclHelper.admin)) {
                    return o1.equals(AclHelper.admin) ? 0 : 1;
                }
                return MiscUtil.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
            return MiscUtil.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
        }
    };

    public static void clone(AclPrincipal principal, AclRegistry sourceRegistry, AclRegistry targetRegistry, AclChangeRegistry sourceChangeRegistry, AclChangeRegistry targetChangeRegistry) throws Exception {
        AclEntry targetEntry;
        for (AclEntry sourceEntry : sourceRegistry.getPrincipalEntries(principal.getId())) {
            targetEntry = (AclEntry)XCloneHelper.clone((XCloneable)sourceEntry);
            targetRegistry.addEntry(targetEntry);
        }
        for (AclChangeRegistry.AclEntryChange sourceEntryChange : sourceChangeRegistry.getEntries().getKey1Values((Object)principal.getId())) {
            targetEntry = sourceEntryChange.getType() != AclChangeRegistry.AclChangeType.DELETE ? targetRegistry.getEntry(sourceEntryChange.getData().getEntry().getPrincipalId(), sourceEntryChange.getData().getEntry().getResourceId()) : (AclEntry)XCloneHelper.clone((XCloneable)sourceEntryChange.getData().getEntry());
            if (targetEntry == null) continue;
            AclChangeRegistry.AclEntryData targetEntryData = new AclChangeRegistry.AclEntryData();
            targetEntryData.setEntry(targetEntry);
            AclChangeRegistry.AclEntryChange targetEntryChange = new AclChangeRegistry.AclEntryChange();
            targetEntryChange.setType(sourceEntryChange.getType());
            targetEntryChange.setData(targetEntryData);
            targetChangeRegistry.getEntries().put((Object)sourceEntryChange.getData().getEntry().getPrincipalId(), (Object)sourceEntryChange.getData().getEntry().getResourceId(), (Object)targetEntryChange);
        }
    }

    public static void merge(AclPrincipal principal, AclRegistry sourceRegistry, AclRegistry targetRegistry, AclChangeRegistry sourceChangeRegistry, AclChangeRegistry targetChangeRegistry) {
        for (AclEntry targetEntry : targetRegistry.getPrincipalEntries(principal.getId())) {
            targetRegistry.removeEntry(targetEntry);
        }
        for (AclEntry sourceEntry : sourceRegistry.getPrincipalEntries(principal.getId())) {
            targetRegistry.addEntry(sourceEntry);
        }
        targetChangeRegistry.getEntries().removeKey1Values((Object)principal.getId());
        for (AclChangeRegistry.AclEntryChange sourceEntryChange : sourceChangeRegistry.getEntries().getKey1Values((Object)principal.getId())) {
            targetChangeRegistry.getEntries().put((Object)sourceEntryChange.getData().getEntry().getPrincipalId(), (Object)sourceEntryChange.getData().getEntry().getResourceId(), (Object)sourceEntryChange);
        }
    }

    public static void cleanRules(Collection<AclRule> rules) {
        Iterator<AclRule> rulesIterator = rules.iterator();
        while (rulesIterator.hasNext()) {
            AclRule rule = rulesIterator.next();
            AclEditorHelper.cleanActions(rule.getActions());
            AclEditorHelper.cleanRestrictions(rule.getPropertyRestrictionGroups());
            AclEditorHelper.cleanFields(rule.getFieldRestrictions());
            if (AclEditorHelper.isConsistent(rule)) continue;
            rulesIterator.remove();
        }
    }

    public static void cleanActions(Collection<AclAction> actions) {
        Iterator<AclAction> actionsIterator = actions.iterator();
        while (actionsIterator.hasNext()) {
            AclAction action = actionsIterator.next();
            if (AclEditorHelper.isConsistent(action)) continue;
            actionsIterator.remove();
        }
    }

    public static void cleanRestrictions(Collection<AclPropertyRestrictionGroup> restrictionGroups) {
        Iterator<AclPropertyRestrictionGroup> restrictionGroupsIterator = restrictionGroups.iterator();
        while (restrictionGroupsIterator.hasNext()) {
            AclPropertyRestrictionGroup restrictionGroup = restrictionGroupsIterator.next();
            if (restrictionGroup.getType() == AclPropertyRestrictionGroupType.SIMPLE || restrictionGroup.getType() == AclPropertyRestrictionGroupType.NOT) {
                AclPropertyRestriction restrictionValue = (AclPropertyRestriction)restrictionGroup.getValue();
                if (AclEditorHelper.isConsistent(restrictionValue)) continue;
                restrictionGroupsIterator.remove();
                continue;
            }
            if (restrictionGroup.getType() != AclPropertyRestrictionGroupType.AND && restrictionGroup.getType() != AclPropertyRestrictionGroupType.OR) continue;
            List childRestrictionGroups = (List)restrictionGroup.getValue();
            AclEditorHelper.cleanRestrictions(childRestrictionGroups);
            if (!childRestrictionGroups.isEmpty()) continue;
            restrictionGroupsIterator.remove();
        }
    }

    public static void cleanFields(Collection<AclFieldRestriction> fields) {
        Iterator<AclFieldRestriction> fieldsIterator = fields.iterator();
        while (fieldsIterator.hasNext()) {
            AclFieldRestriction field = fieldsIterator.next();
            if (AclEditorHelper.isConsistent(field)) continue;
            fieldsIterator.remove();
        }
    }

    public static boolean isConsistent(AclRule rule) {
        return rule.getActions().size() > 0;
    }

    public static boolean isConsistent(AclAction action) {
        return action.getOperationId() != null && action.getPermission() != null;
    }

    public static boolean isConsistent(AclPropertyRestriction restriction) {
        return restriction.getPropertyId() != null && restriction.getConditionId() != null && RestrictionResourcesRegistry.get().getCondition(restriction.getConditionId()) != null && (!RestrictionResourcesRegistry.get().getCondition(restriction.getConditionId()).hasRightSide() || restriction.getValue() != null);
    }

    public static boolean isConsistent(AclFieldRestriction field) {
        return field.getFieldId() != null;
    }

    public static boolean isEmpty(AclRule rule) {
        return rule.getActions().isEmpty() && rule.getPropertyRestrictionGroups().isEmpty() && rule.getFieldRestrictions().isEmpty();
    }

    public static boolean isEmpty(AclAction action) {
        return action.getOperationId() == null && action.getPermission() == null;
    }

    public static boolean isEmpty(AclPropertyRestriction restriction) {
        return restriction.getPropertyId() == null && restriction.getConditionId() == null && restriction.getValue() == null;
    }

    public static boolean isEmpty(AclFieldRestriction field) {
        return field.getFieldId() == null;
    }

    public static String toString(AclChangeRegistry registry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugUtil.decorate((Iterable)registry.getGroups().values().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"groups", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)registry.getUsers().values().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"users", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)registry.getEntries().values().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"entries", (boolean)true));
        return stringBuilder.toString();
    }

    private static <P extends AclPrincipal, D extends AclChangeRegistry.AclPrincipalData<P>> String toString(AclChangeRegistry.AclChange<P, D> change) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type -> " + change.getType());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((String)AclEditorHelper.toString(change.getData()), null, (String)"data", (boolean)true));
        return stringBuilder.toString();
    }

    private static <P extends AclPrincipal> String toString(AclChangeRegistry.AclPrincipalData<P> data) {
        if (data instanceof AclChangeRegistry.AclGroupData) {
            return AclEditorHelper.toString((AclChangeRegistry.AclGroupData)data);
        }
        if (data instanceof AclChangeRegistry.AclUserData) {
            return AclEditorHelper.toString((AclChangeRegistry.AclUserData)data);
        }
        return "?";
    }

    private static String toString(AclChangeRegistry.AclGroupData data) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugUtil.decorate((String)AclEditorHelper.toString((AclGroup)data.getPrincipal()), null, (String)"pricipal", (boolean)true));
        return stringBuilder.toString();
    }

    private static String toString(AclChangeRegistry.AclUserData data) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugUtil.decorate((String)AclEditorHelper.toString((AclUser)data.getPrincipal()), null, (String)"principal", (boolean)true));
        stringBuilder.append("account -> " + data.getAccount());
        stringBuilder.append("\n");
        stringBuilder.append("password -> " + data.getPassword());
        stringBuilder.append("\n");
        stringBuilder.append("profile -> " + data.getProfile());
        stringBuilder.append("\n");
        stringBuilder.append("userChanged -> " + data.isUserChanged());
        stringBuilder.append("\n");
        stringBuilder.append("accountChanged -> " + data.isAccountChanged());
        stringBuilder.append("\n");
        stringBuilder.append("profileChanged -> " + data.isProfileChanged());
        return stringBuilder.toString();
    }

    private static String toString(AclChangeRegistry.AclEntryChange change) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("type -> " + change.getType());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((String)AclEditorHelper.toString(change.getData()), null, (String)"data", (boolean)true));
        return stringBuilder.toString();
    }

    private static String toString(AclChangeRegistry.AclEntryData data) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugUtil.decorate((String)AclEditorHelper.toString(data.getEntry()), null, (String)"entry", (boolean)true));
        return stringBuilder.toString();
    }

    public static String toString(AclRegistry registry) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList rootItems = new ArrayList();
        rootItems.addAll(registry.getGroups().stream().filter(value -> value.getParentId() == null).sorted(principalComparator).collect(Collectors.toList()));
        rootItems.addAll(registry.getUsers().stream().filter(value -> value.getGroupIds().isEmpty()).sorted(principalComparator).collect(Collectors.toList()));
        stringBuilder.append(DebugUtil.decorate((String)FxUtil.toString(rootItems, item -> {
            if (item instanceof AclGroup) {
                ArrayList children = new ArrayList();
                children.addAll(registry.getGroupChildren(item.getId()).stream().map(value -> registry.getGroup(value)).filter(value -> value != null).sorted(principalComparator).collect(Collectors.toList()));
                children.addAll(registry.getGroupUsers(item.getId()).stream().map(value -> registry.getUser(value)).filter(value -> value != null).sorted(principalComparator).collect(Collectors.toList()));
                return children;
            }
            return Collections.emptyList();
        }, value -> String.format("%s (%s)", value.getName(), value.getId())), null, (String)"principals", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)registry.getEntries().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"entries", (boolean)true));
        return stringBuilder.toString();
    }

    public static <P extends AclPrincipal> String toString(P principal) {
        if (principal instanceof AclGroup) {
            return AclEditorHelper.toString((AclGroup)principal);
        }
        if (principal instanceof AclUser) {
            return AclEditorHelper.toString((AclUser)principal);
        }
        return "?";
    }

    public static String toString(AclGroup group) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id -> " + group.getId());
        stringBuilder.append("\n");
        stringBuilder.append("name -> " + group.getName());
        stringBuilder.append("\n");
        stringBuilder.append("description -> " + group.getDescription());
        stringBuilder.append("\n");
        stringBuilder.append("parentId -> " + group.getParentId());
        return stringBuilder.toString();
    }

    public static String toString(AclUser user) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("id -> " + user.getId());
        stringBuilder.append("\n");
        stringBuilder.append("name -> " + user.getName());
        stringBuilder.append("\n");
        stringBuilder.append("description -> " + user.getDescription());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((Iterable)user.getGroupIds(), null, (String)"groupIds", (boolean)true));
        return stringBuilder.toString();
    }

    public static String toString(AclEntry entry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("principalId -> " + entry.getPrincipalId());
        stringBuilder.append("\n");
        stringBuilder.append("resourceId -> " + entry.getResourceId());
        stringBuilder.append("\n");
        stringBuilder.append(DebugUtil.decorate((Iterable)entry.getRules().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"rules", (boolean)true));
        return stringBuilder.toString();
    }

    private static String toString(AclRule rule) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DebugUtil.decorate((Iterable)rule.getActions().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"actions", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((String)FxUtil.toString((Collection)rule.getPropertyRestrictionGroups(), value -> value.getType() != AclPropertyRestrictionGroupType.SIMPLE && value.getType() != AclPropertyRestrictionGroupType.NOT ? (List)value.getValue() : Collections.emptyList(), value -> AclEditorHelper.toString(value)), null, (String)"restrictions", (boolean)true));
        stringBuilder.append(DebugUtil.decorate((Iterable)rule.getFieldRestrictions().stream().map(value -> AclEditorHelper.toString(value)).collect(Collectors.toList()), null, (String)"fields", (boolean)true));
        return stringBuilder.toString();
    }

    private static String toString(AclAction action) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("operationId -> " + action.getOperationId());
        stringBuilder.append("\n");
        stringBuilder.append("permission -> " + action.getPermission());
        return stringBuilder.toString();
    }

    private static String toString(AclPropertyRestrictionGroup item) {
        if (item.getType() == AclPropertyRestrictionGroupType.SIMPLE || item.getType() == AclPropertyRestrictionGroupType.NOT) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(item.getType().name());
            AclPropertyRestriction propertyRestriction = (AclPropertyRestriction)item.getValue();
            if (propertyRestriction != null) {
                stringBuilder.append(" ");
                stringBuilder.append(propertyRestriction.getPropertyId() != null ? propertyRestriction.getPropertyId() : "?");
                stringBuilder.append(" ");
                stringBuilder.append(propertyRestriction.getConditionId() != null ? propertyRestriction.getConditionId() : "?");
                if (propertyRestriction.getValue() != null) {
                    stringBuilder.append(" ");
                    stringBuilder.append(propertyRestriction.getValue());
                }
            } else {
                stringBuilder.append(" ");
                stringBuilder.append("?");
            }
            return stringBuilder.toString();
        }
        if (item.getType() == AclPropertyRestrictionGroupType.AND || item.getType() == AclPropertyRestrictionGroupType.OR) {
            return item.getType().name();
        }
        return "?";
    }

    private static String toString(AclFieldRestriction field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("fieldId -> " + field.getFieldId());
        return stringBuilder.toString();
    }
}

