/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.text.RichTextFlow;
import com.gridnine.xtrip.client.fx.core.lib.components.text.TextHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.NodeRenderer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RendererWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.StandardTableWidgetCoordinator;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ExpandableColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.RendererWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorRestrictionResourceHandlersRegistry;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorRulePane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiPredicate;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;

class AclEditorRulesPane
extends StackPane
implements DevTool {
    private TableWidgetController<TableWidget<AclRule>, AclRule> rulesTable;
    private RendererWidgetColumn<AclRule> nameColumn;
    private ExpandableColumn<AclRule, Node> ruleColumn;
    private AclChangeRegistry.AclEntryData entryData;

    AclEditorRulesPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane rulesPane = this.createRulesPane();
        rulesPane.getStyleClass().add((Object)"acl-rules-pane");
        this.getChildren().setAll((Object[])new Node[]{rulesPane});
    }

    private Pane createRulesPane() {
        this.rulesTable = new TableWidgetController<TableWidget<AclRule>, AclRule>(){
            private final TableWidget<AclRule> view = new TableWidget(false);
            {
                this.view.setPlaceholder(Messages.No_data_to_view);
            }

            public TableWidget<AclRule> getView() {
                return this.view;
            }
        };
        ((TableWidget)this.rulesTable.getView()).setControlButtonsAvailability(ControlsPane.ADD_REMOVE_REORDERING);
        ((TableWidget)this.rulesTable.getView()).setItemsProvider(() -> new AclRule());
        ArrayList<Object> columns = new ArrayList<Object>();
        this.nameColumn = new RendererWidgetColumn<AclRule>(entry -> null, (entry, value) -> {}){

            public boolean isDataChanged(AclRule model, RendererWidget node) {
                return false;
            }
        };
        this.nameColumn.setRenderer((NodeRenderer)new NameRenderer());
        this.nameColumn.setCaption(Messages.Name);
        this.nameColumn.setId("name");
        columns.add(this.nameColumn);
        this.ruleColumn = new ExpandableColumn<AclRule, Node>(){

            protected Node createView() {
                return AclEditorRestrictionResourceHandlersRegistry.get().getHandler(AclEditorRulesPane.this.entryData).createEditor(AclEditorRulesPane.this.entryData);
            }

            public void readData(AclRule model, ExpandableColumn.ViewHolder<Node> node) {
                ((AclEditorRulePane)node.getView()).readData(model);
                node.setExpanded(true);
            }

            public void writeData(AclRule model, ExpandableColumn.ViewHolder<Node> node) {
                ((AclEditorRulePane)node.getView()).writeData(model);
            }

            public void setReadonly(ExpandableColumn.ViewHolder<Node> node, boolean readonly) {
            }

            public void setAclNotEditable(ExpandableColumn.ViewHolder<Node> node) {
            }

            public boolean isDataChanged(AclRule model, ExpandableColumn.ViewHolder<Node> node) {
                return ((AclEditorRulePane)node.getView()).isDataChanged();
            }
        };
        this.ruleColumn.setCaption(null);
        this.ruleColumn.setId("rule");
        columns.add(this.ruleColumn);
        ((TableWidget)this.rulesTable.getView()).setColumns(columns);
        return (Pane)this.rulesTable.getView();
    }

    private void createBindings() {
    }

    private void createListeners() {
        ((TableWidget)this.rulesTable.getView()).setOnRowsAction(event -> {
            for (int i = 0; i < ((TableWidget)this.rulesTable.getView()).getRowsCount(); ++i) {
                ((RendererWidget)this.nameColumn.getWidget(i)).setValue((Object)Messages.getRule_N(i + 1));
            }
        });
    }

    public boolean isDataChanged() {
        return this.rulesTable.isDataChanged();
    }

    public void readData(AclChangeRegistry.AclEntryData model) {
        this.entryData = model;
        boolean multipleRulesSupported = AclEditorRestrictionResourceHandlersRegistry.get().getHandler(this.entryData).isMultipleRulesSuuported();
        if (multipleRulesSupported) {
            ((TableWidget)this.rulesTable.getView()).setControlButtonsCoordinator((BiPredicate)new StandardTableWidgetCoordinator((TableWidget)this.rulesTable.getView()){});
        } else {
            ((TableWidget)this.rulesTable.getView()).setControlButtonsCoordinator((BiPredicate)new StandardTableWidgetCoordinator((TableWidget)this.rulesTable.getView()){

                public boolean test(ControlsPane.ButtonType buttonType, Integer rowNumber) {
                    if (rowNumber != null && buttonType == ControlsPane.ButtonType.ADD) {
                        return false;
                    }
                    return super.test(buttonType, rowNumber);
                }
            });
        }
        this.rulesTable.readData((Collection)model.getEntry().getRules());
    }

    public void writeData(AclChangeRegistry.AclEntryData model) {
        this.rulesTable.writeData((Collection)model.getEntry().getRules());
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(AclEditorRulesPane.this.rulesTable.getView());
            }

            public String getInfo() {
                return ((Object)((Object)AclEditorRulesPane.this)).getClass().getSimpleName();
            }
        };
    }

    private static class NameRenderer
    implements NodeRenderer {
        private NameRenderer() {
        }

        public Node createNode(boolean readonly) {
            return new GridPane();
        }

        public Object getValue(Node node) {
            return node.getUserData();
        }

        public void setValue(Node node, Object value) {
            node.setUserData(value);
            GridPane pane = (GridPane)node;
            pane.getChildren().clear();
            RichTextFlow nameTextFlow = new RichTextFlow(TextHandler.SIMPLE_HTML);
            nameTextFlow.setText("<html>" + value);
            UiUtil.gridPosition((GridPane)pane, (Node)nameTextFlow).col(0).row(0).colSpan(1).rowSpan(1).hAlignment(HPos.LEFT).vAlignment(VPos.TOP).hGrow(Priority.ALWAYS).vGrow(Priority.ALWAYS).place();
        }

        public void setReadonly(boolean readonly, Node node) {
        }
    }
}

