/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.acl;

import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CheckBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PasswordFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.standard.acl.AclEditorPane;
import com.gridnine.xtrip.client.fx.standard.acl.AclPrincipalChangedEvent;
import com.gridnine.xtrip.client.fx.standard.helpers.UserAccountHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.settings.UserSettingsHandler;
import com.gridnine.xtrip.common.fx.security.acl.AclChangeRegistry;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

class AclEditorUserParametersPane
extends StackPane
implements AclEditorPane.AclPrincipalEditor<AclUser, AclChangeRegistry.AclUserData> {
    private GridCell<TextFieldWidget> nameCell;
    private GridCell<TextFieldWidget> descriptionCell;
    private GridCell<EntityBoxWidget<Person>> profileCell;
    private GridCell<TextFieldWidget> idCell;
    private GridCell<PasswordFieldWidget> passwordCell;
    private GridCell<CheckBoxWidget> activeCell;
    private AclChangeRegistry.AclUserData data;
    private boolean changed;
    private boolean initialized;

    AclEditorUserParametersPane() {
        this.createGUI();
        this.createBindings();
        this.createListeners();
    }

    private void createGUI() {
        Pane editorPane = this.createEditorPane();
        this.getChildren().setAll((Object[])new Node[]{editorPane});
    }

    private Pane createEditorPane() {
        this.nameCell = new GridCell(Messages.Name, (Node)new TextFieldWidget(false));
        this.descriptionCell = new GridCell(Messages.Description, (Node)new TextFieldWidget(false));
        this.profileCell = new GridCell(Messages.Profile, (Node)new EntityBoxWidget(Person.class, false));
        this.idCell = new GridCell(Messages.Login, (Node)new TextFieldWidget(false));
        this.passwordCell = new GridCell(Messages.Password, (Node)new PasswordFieldWidget(false));
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setShowStrengthIndicator(true);
        this.activeCell = new GridCell((Node)new CheckBoxWidget(false));
        ((CheckBoxWidget)this.activeCell.getPayload()).setText(Messages.Active);
        GridContainer editorPane = new GridContainer(3);
        editorPane.getCells().addAll((Object[])new GridCell[]{this.nameCell, this.descriptionCell, this.profileCell, this.idCell, this.passwordCell, this.activeCell});
        return editorPane;
    }

    private void createBindings() {
    }

    private void createListeners() {
        ((TextFieldWidget)this.nameCell.getPayload()).valueProperty().addListener((observable, oldValue, newValue) -> {
            if (this.initialized) {
                ((AclUser)this.data.getPrincipal()).setName(!TextUtil.isBlank((String)newValue) ? newValue : null);
                this.data.setUserChanged(true);
                this.data.setAccountChanged(true);
                this.changed = true;
                EventBus.get().publishSync((Event)new AclPrincipalChangedEvent(AclPrincipalChangedEvent.ChangeType.NAME));
            }
        });
    }

    @Override
    public Card<Node> getContent() {
        return new Card("parameters", UiCardsContainer.Style.STATIC, Messages.General_parameters, (Node)this);
    }

    @Override
    public boolean isDataChanged() {
        if (this.data == null) {
            return false;
        }
        if (this.changed) {
            return true;
        }
        if (!MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getName(), (Object)((TextFieldWidget)this.nameCell.getPayload()).getValue())) {
            return true;
        }
        if (!MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getDescription(), (Object)((TextFieldWidget)this.descriptionCell.getPayload()).getValue())) {
            return true;
        }
        if (!MiscUtil.equals((Object)this.data.getProfile(), (Object)((EntityBoxWidget)this.profileCell.getPayload()).getValue())) {
            return true;
        }
        if (!MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getId(), (Object)((TextFieldWidget)this.idCell.getPayload()).getValue())) {
            return true;
        }
        if (!TextUtil.isBlank((String)((PasswordFieldWidget)this.passwordCell.getPayload()).getValue(), (boolean)false)) {
            return true;
        }
        return this.data.getAccount().isActive() != ((CheckBoxWidget)this.activeCell.getPayload()).isSelected();
    }

    @Override
    public void readData(AclChangeRegistry.AclUserData model) {
        String login = ((AclUser)model.getPrincipal()).getId();
        List handlers = ClientRegistry.get().allOf(UserSettingsHandler.TYPE).values().stream().filter(handler -> handler.getLogin() != null && handler.getLogin().equals(login) && handler.isEnabled()).collect(Collectors.toList());
        boolean readOnly = !handlers.isEmpty();
        this.initialized = false;
        this.data = model;
        this.changed = false;
        ((TextFieldWidget)this.nameCell.getPayload()).setValue(((AclUser)model.getPrincipal()).getName());
        ((TextFieldWidget)this.descriptionCell.getPayload()).setValue(((AclUser)model.getPrincipal()).getDescription());
        ((EntityBoxWidget)this.profileCell.getPayload()).setValue(model.getProfile());
        ((TextFieldWidget)this.idCell.getPayload()).setValue(((AclUser)model.getPrincipal()).getId());
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setValue(null);
        ((CheckBoxWidget)this.activeCell.getPayload()).setSelected(model.getAccount().isActive());
        ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(((AclUser)model.getPrincipal()).getId() != null);
        ((CheckBoxWidget)this.activeCell.getPayload()).getViewState().setReadonly(AclHelper.isSpecialUser((AclUser)((AclUser)model.getPrincipal())) || readOnly);
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setPromptText(model.getAccount().getPasswordDigest() != null || !TextUtil.isBlank((String)model.getPassword(), (boolean)false) ? String.join((CharSequence)"", Collections.nCopies(25, "*")) : UiUtil.NULL_TEXT);
        ((PasswordFieldWidget)this.passwordCell.getPayload()).getViewState().setReadonly(readOnly);
        if (readOnly) {
            this.passwordCell.setHelp(() -> new QuickHelp(UserAccountHelper.passwordAvailabilityInfo(true, login, handlers.stream().map(UserSettingsHandler::getMessage).collect(Collectors.toList()))));
        } else {
            this.passwordCell.setHelp(null);
        }
        this.initialized = true;
    }

    @Override
    public void writeData(AclChangeRegistry.AclUserData model) {
        this.data = model;
        this.changed = false;
        if (!model.isUserChanged()) {
            model.setUserChanged(!MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getName(), (Object)((TextFieldWidget)this.nameCell.getPayload()).getValue()) || !MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getDescription(), (Object)((TextFieldWidget)this.descriptionCell.getPayload()).getValue()) || !MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getId(), (Object)((TextFieldWidget)this.idCell.getPayload()).getValue()));
        }
        if (!model.isAccountChanged()) {
            model.setAccountChanged(!MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getName(), (Object)((TextFieldWidget)this.nameCell.getPayload()).getValue()) || !MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getDescription(), (Object)((TextFieldWidget)this.descriptionCell.getPayload()).getValue()) || !MiscUtil.equals((Object)((AclUser)this.data.getPrincipal()).getId(), (Object)((TextFieldWidget)this.idCell.getPayload()).getValue()) || !TextUtil.isBlank((String)((PasswordFieldWidget)this.passwordCell.getPayload()).getValue(), (boolean)false) || !TextUtil.isBlank((String)this.data.getPassword(), (boolean)false) || this.data.getAccount().isActive() != ((CheckBoxWidget)this.activeCell.getPayload()).isSelected());
        }
        if (!model.isProfileChanged()) {
            model.setProfileChanged(!MiscUtil.equals((Object)this.data.getProfile(), (Object)((EntityBoxWidget)this.profileCell.getPayload()).getValue()));
        }
        ((AclUser)model.getPrincipal()).setName(((TextFieldWidget)this.nameCell.getPayload()).getValue());
        ((AclUser)model.getPrincipal()).setDescription(((TextFieldWidget)this.descriptionCell.getPayload()).getValue());
        model.setProfile(((EntityBoxWidget)this.profileCell.getPayload()).getValue());
        ((AclUser)model.getPrincipal()).setId(((TextFieldWidget)this.idCell.getPayload()).getValue());
        model.getAccount().setFullName(((TextFieldWidget)this.nameCell.getPayload()).getValue());
        model.getAccount().setNotes(((TextFieldWidget)this.descriptionCell.getPayload()).getValue());
        model.getAccount().setLoginName(((TextFieldWidget)this.idCell.getPayload()).getValue());
        if (!TextUtil.isBlank((String)((PasswordFieldWidget)this.passwordCell.getPayload()).getValue(), (boolean)false)) {
            model.setPassword(((PasswordFieldWidget)this.passwordCell.getPayload()).getValue());
        }
        String login = ((AclUser)model.getPrincipal()).getId();
        List handlers = ClientRegistry.get().allOf(UserSettingsHandler.TYPE).values().stream().filter(handler -> handler.getLogin() != null && handler.getLogin().equals(login) && handler.isEnabled()).collect(Collectors.toList());
        boolean readOnly = !handlers.isEmpty();
        model.getAccount().setActive(((CheckBoxWidget)this.activeCell.getPayload()).isSelected());
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setValue(null);
        ((TextFieldWidget)this.idCell.getPayload()).getViewState().setReadonly(((AclUser)model.getPrincipal()).getId() != null);
        ((CheckBoxWidget)this.activeCell.getPayload()).getViewState().setReadonly(AclHelper.isSpecialUser((AclUser)((AclUser)model.getPrincipal())) || readOnly);
        ((PasswordFieldWidget)this.passwordCell.getPayload()).setPromptText(model.getAccount().getPasswordDigest() != null || !TextUtil.isBlank((String)model.getPassword(), (boolean)false) ? String.join((CharSequence)"", Collections.nCopies(25, "*")) : UiUtil.NULL_TEXT);
        ((PasswordFieldWidget)this.passwordCell.getPayload()).getViewState().setReadonly(readOnly);
        if (readOnly) {
            this.passwordCell.setHelp(() -> new QuickHelp(UserAccountHelper.passwordAvailabilityInfo(true, login, handlers.stream().map(UserSettingsHandler::getMessage).collect(Collectors.toList()))));
        } else {
            this.passwordCell.setHelp(null);
        }
    }
}

