/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.assets;

import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.assets.AssetHandler;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.editor.AssetEditorPane;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.service.AssetEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.assets.AssetEditorParameters;
import com.gridnine.xtrip.client.fx.standard.assets.editor.AclUserEditorPane;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;

public class AssetEditorActivityHandler
extends ActivityHandler<AssetEditorPane<?>, AssetEditorParameters> {
    private static String ID = "asset-editor-activity-handler";
    private final Consumer<AssetModificationEvent> modificationEventHandler = evt -> {
        List assets = evt.getModifications().stream().filter(mod -> mod.getType() == AssetModification.ModificationType.DELETE).map(mod -> mod.getAsset()).collect(Collectors.toList());
        if (assets.isEmpty()) {
            return;
        }
        FxUtil.runInFxThread(() -> this.closeActivities(assets));
    };

    public static AssetEditorActivityHandler get() {
        return (AssetEditorActivityHandler)AssetEditorActivityHandler.forId((String)ID);
    }

    public static String buildToken(AssetHandler<?> handler, String assetUid) {
        return handler.getId() + '|' + assetUid;
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new AssetEditorActivityHandler());
        }
    }

    private AssetEditorActivityHandler() {
        Environment.publish(AssetEditingService.class, asset -> {
            AssetHandler handler = AssetHandler.forAssetClass(asset.getClass());
            if (handler == null) {
                StandardNotifications.VIEWER_NOT_SUPPORTED.show(asset.getClass().getName());
                return;
            }
            NavigationParameters parameters = new NavigationParameters();
            parameters.setParameters((Object)new AssetEditorParameters(handler.getId(), asset.getUid()));
            ActivityManager.get().navigate(AssetEditorActivityHandler.buildToken(handler, asset.getUid()), (ActivityHandler)AssetEditorActivityHandler.get(), parameters);
        });
        EventBus.get().subscribe(AssetModificationEvent.TYPE, this.modificationEventHandler);
    }

    private void closeActivities(List<BaseAsset> assets) {
        for (BaseAsset asset : assets) {
            AssetHandler handler = AssetHandler.forAssetClass(asset.getClass());
            if (handler == null) continue;
            ActivityManager.get().remove(AssetEditorActivityHandler.buildToken(handler, asset.getUid()), true);
        }
    }

    public String getId() {
        return ID;
    }

    protected boolean isHighlighted(ActivityState<AssetEditorPane<?>, AssetEditorParameters> state) {
        return true;
    }

    protected AssetEditorPane<?> createView(ActivityState<AssetEditorPane<?>, AssetEditorParameters> state) {
        state.setStateful(((AssetEditorParameters)state.getParameters()).getAssetUid() != null);
        AssetHandler handler = AssetHandler.forId((String)((AssetEditorParameters)state.getParameters()).getHandlerId());
        AclUserEditorPane result = AclUser.class.isAssignableFrom(handler.getAssetType()) ? new AclUserEditorPane(state.getMutex(), (AssetHandler<AclUser>)handler, ((AssetEditorParameters)state.getParameters()).getAssetUid()) : new AssetEditorPane(state.getMutex(), handler, ((AssetEditorParameters)state.getParameters()).getAssetUid());
        FxUtil.bind((Property)state.titleProperty(), (ObservableValue)result.titleProperty());
        FxUtil.bind((Property)state.descriptionProperty(), (ObservableValue)result.descriptionProperty());
        result.assetUidProperty().addListener((obj, oldValue, newValue) -> {
            ((AssetEditorParameters)state.getParameters()).setAssetUid((String)newValue);
            state.setStateful(newValue != null);
            state.parametersChanged();
            state.setToken(AssetEditorActivityHandler.buildToken(handler, newValue));
        });
        Notifications.get().submitTask(() -> result.reloadData(), result.getMutex());
        return result;
    }

    protected boolean hasChanges(ActivityState<AssetEditorPane<?>, AssetEditorParameters> state) {
        AssetEditorPane view = (AssetEditorPane)this.getView(state);
        return view != null && view.isDataChanged();
    }

    protected void saveChanges(ActivityState<AssetEditorPane<?>, AssetEditorParameters> state) throws Exception {
        AssetEditorPane view = (AssetEditorPane)this.getView(state);
        if (view == null) {
            return;
        }
        view.saveData();
    }

    protected Serializer<AssetEditorParameters> getSerializer() {
        return AssetEditorParameters.SERIALIZER;
    }
}

