/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.assets.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListAction;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.assets.FxWorkspace;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.security.acl.helper.AclHelper;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.Control;

public class DeleteAclUserListAction
implements AssetsListAction {
    static void showDialog(final List<BaseAsset> users) {
        Dialog dialog = new Dialog();
        dialog.setMessage(Messages.Delete_selected_elements);
        dialog.addButton(DialogButtonStyle.DECLINE, Messages.Cancel, () -> ((Dialog)dialog).close());
        dialog.addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Delete, () -> Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Delete_ACL;
            }

            protected void execute() throws Exception {
                ArrayList<AssetModification> assetModifications = new ArrayList<AssetModification>();
                ArrayList<EntityModification> entityModifications = new ArrayList<EntityModification>();
                float progress = 0.0f;
                float step = 100 / users.size();
                for (BaseAsset user : users) {
                    try {
                        if (AclHelper.isSpecialUser((AclUser)((AclUser)user))) {
                            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Cannot_be_deleted, (Object[])new Object[]{user})});
                        } else {
                            EntityContainer profileContainer;
                            ((AssetService)RpcServiceManager.get().getService(AssetService.class)).delete(ServiceInvocationContext.get(), user);
                            this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Object_deleted, (Object[])new Object[]{user})});
                            assetModifications.add(new AssetModification(user, AssetModification.ModificationType.DELETE));
                            SearchQuery query = new SearchQuery();
                            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.loginName.name(), (Object)((AclUser)user).getId()));
                            List indexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), PersonIndex.class, query);
                            if (indexes.size() > 0 && (profileContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), ((PersonIndex)indexes.get(0)).getSource())) != null) {
                                ((Person)profileContainer.getEntity()).setLoginName(null);
                                profileContainer.getVersionInfo().setDataSource("fx-editor");
                                profileContainer.getVersionInfo().setVersionNotes("Delete Acl User");
                                profileContainer = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), profileContainer, null, true);
                                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Object_associated_with, (Object[])new Object[]{user, profileContainer.toReference()})});
                                entityModifications.add(new EntityModification(profileContainer.toReference(), EntityModification.ModificationType.DELETE));
                            }
                            query = new SearchQuery();
                            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)UserAccount.Property.loginName.name(), (Object)((AclUser)user).getId()));
                            query.getPreferredProperties().add(UserAccount.Property.loginName.name());
                            List accounts = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), UserAccount.class, query).getData();
                            if (accounts.size() > 0) {
                                UserAccount account = (UserAccount)accounts.get(0);
                                ((ModelService)RpcServiceManager.get().getService(ModelService.class)).deleteUserAccount(ServiceInvocationContext.get(), account.getLoginName());
                                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleted_Object_associated_with, (Object[])new Object[]{user, account})});
                                assetModifications.add(new AssetModification((BaseAsset)account, AssetModification.ModificationType.DELETE));
                            }
                            query = new SearchQuery();
                            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)FxWorkspace.Property.owner.name(), (Object)((AclUser)user).getId()));
                            query.getPreferredProperties().add(FxWorkspace.Property.owner.name());
                            List workspaces = ((AssetService)RpcServiceManager.get().getService(AssetService.class)).search(ServiceInvocationContext.get(), FxWorkspace.class, query).getData();
                            if (workspaces.size() > 0) {
                                FxWorkspace workspace = (FxWorkspace)workspaces.get(0);
                                ((AssetService)RpcServiceManager.get().getService(AssetService.class)).delete(ServiceInvocationContext.get(), (BaseAsset)workspace);
                                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Deleted_Object_associated_with, (Object[])new Object[]{user, workspace})});
                                assetModifications.add(new AssetModification((BaseAsset)workspace, AssetModification.ModificationType.DELETE));
                            }
                        }
                    }
                    catch (Exception e) {
                        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Error_delete, (Throwable)e, (Object[])new Object[]{user})});
                    }
                    this.setProgress((byte)(progress += step), "");
                }
                EventBus.get().publishAsync((Event)new AssetModificationEvent(assetModifications));
                EventBus.get().publishAsync((Event)new EntityModificationEvent(null, entityModifications));
            }
        }));
        dialog.show(Dialog.getGlobalWindow());
    }

    public ActionIcon getIcon(AssetsListPane context) {
        return StandardActionIcons.DELETE;
    }

    public String getId() {
        return "acl-user-delete";
    }

    public double getWeight() {
        return 20.0;
    }

    public boolean isEnabled(AssetsListPane context) {
        if (!context.getAssetHandler().getAssetType().equals(AclUser.class)) {
            return false;
        }
        int count = 0;
        for (BaseAsset user : context.getSelectedItems()) {
            if (!AclHelper.isSpecialUser((AclUser)((AclUser)user))) continue;
            ++count;
        }
        return !context.getSelectedItems().isEmpty() && context.getSelectedItems().size() != count;
    }

    public boolean isAvailable(AssetsListPane context) {
        return context.getAssetHandler().getAssetType().equals(AclUser.class);
    }

    public void execute(Control source, AssetsListPane context, boolean alt) {
        List users = context.getSelectedItems();
        if (users.isEmpty()) {
            return;
        }
        DeleteAclUserListAction.showDialog(users);
    }
}

