/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.assets.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.assets.AssetModification;
import com.gridnine.xtrip.client.fx.core.assets.AssetModificationEvent;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListAction;
import com.gridnine.xtrip.client.fx.core.assets.list.AssetsListPane;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.AssetService;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class DeleteAssetAction
implements AssetsListAction {
    public ActionIcon getIcon(AssetsListPane context) {
        return StandardActionIcons.DELETE;
    }

    public String getId() {
        return "asset-delete";
    }

    public double getWeight() {
        return 20.0;
    }

    public boolean isEnabled(AssetsListPane context) {
        if (context.getAssetHandler().getAssetType().equals(AclUser.class)) {
            return false;
        }
        return !context.getSelectedItems().isEmpty();
    }

    public boolean isAvailable(AssetsListPane context) {
        return !context.getAssetHandler().getAssetType().equals(AclUser.class);
    }

    public void execute(Control source, AssetsListPane context, boolean alt) {
        final List assets = context.getSelectedItems();
        if (assets.isEmpty()) {
            return;
        }
        Dialog dialog = new Dialog();
        dialog.setMessage(Messages.Delete_selected_elements);
        dialog.addButton(DialogButtonStyle.DECLINE, Messages.Cancel, () -> ((Dialog)dialog).close());
        dialog.addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Delete, () -> Notifications.get().enqueueAsyncTask(new ClientTask(){

            protected String getTitle() {
                return Messages.Delete_ACL;
            }

            protected void execute() throws Exception {
                float progress = 0.0f;
                float step = 100 / assets.size();
                for (BaseAsset asset2 : assets) {
                    try {
                        ((AssetService)RpcServiceManager.get().getService(AssetService.class)).delete(ServiceInvocationContext.get(), asset2);
                        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)Messages.Object_deleted, (Object[])new Object[]{asset2})});
                    }
                    catch (Exception e) {
                        this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.Error_delete, (Throwable)e, (Object[])new Object[]{asset2})});
                    }
                    this.setProgress((byte)(progress += step), "");
                }
                EventBus.get().publishAsync((Event)new AssetModificationEvent((Collection)assets.stream().map(asset -> new AssetModification(asset, AssetModification.ModificationType.DELETE)).collect(Collectors.toList())));
            }
        }));
        dialog.show((Node)context);
    }
}

