/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.RefillTranzactionPanel;
import com.gridnine.xtrip.common.model.finance.StandardTransactionActions;
import com.gridnine.xtrip.common.model.finance.TransactionAction;
import com.gridnine.xtrip.common.model.finance.TransactionDataHolder;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.search.utils.SearchQueryHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

public class AddOperation {
    public static void createRefillOperation(EntityReference<Organization> organization, Control source, Runnable callback) {
        Notifications.get().submitTask(() -> {
            List suppliers = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).getSupplierList(ServiceInvocationContext.get(), organization);
            FxUtil.waitForFxThread(() -> {
                RefillTranzactionPanel gridConteiner = new RefillTranzactionPanel(false);
                gridConteiner.getCustomerNode().setValue(organization);
                gridConteiner.getCustomerNode().getViewState().setNotEditable(true);
                if (suppliers.size() == 1) {
                    gridConteiner.getSupplierNode().setValue((EntityReference)suppliers.get(0));
                }
                gridConteiner.getSupplierNode().setListParametersSupplier(() -> {
                    IndexListParameters result = new IndexListParameters();
                    result.setIndexType(OrganizationIndex.class);
                    TableColumnSettings col1 = new TableColumnSettings();
                    col1.setId(OrganizationIndex.Property.shortName.name());
                    result.getColumns().add(col1);
                    TableColumnSettings col2 = new TableColumnSettings();
                    col2.setId(OrganizationIndex.Property.name.name());
                    result.getColumns().add(col2);
                    TableColumnSettings col3 = new TableColumnSettings();
                    col3.setId(OrganizationIndex.Property.code.name());
                    result.getColumns().add(col3);
                    TableColumnSettings col4 = new TableColumnSettings();
                    col4.setId(OrganizationIndex.Property.types.name());
                    result.getColumns().add(col4);
                    result.getSortings().put(OrganizationIndex.Property.shortName.name(), SortOrder.ASC);
                    result.getSearchCriterions().add(SearchQueryHelper.buildOrEqStringCriterion((String)"containerUid", (Collection)suppliers.stream().map(EntityReference::getUid).collect(Collectors.toList())));
                    return result;
                });
                gridConteiner.getPaymentTypeNode().guessPrefWidth();
                VBox box = new VBox(new Node[]{gridConteiner});
                Dialog dialog = new Dialog();
                dialog.setTitle(Messages.Balance_editor_refill).setAutoClose(false).setExpandToParent(true).setBody((Node)box).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
                    box.getChildren().removeAll((Collection)box.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
                    ArrayList<MessagePane> msg = new ArrayList<MessagePane>();
                    if (gridConteiner.getSupplierNode().getValue() == null) {
                        msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_supplier));
                    }
                    if (gridConteiner.getPaymentTypeNode().getValue() == null) {
                        msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_payment_type));
                    }
                    if (gridConteiner.getAmountNode().getValue() == null) {
                        msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_amount));
                    }
                    if (gridConteiner.getDateNode().getValue() == null) {
                        msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_date));
                    }
                    if (gridConteiner.getDescriptionNode().getValue() == null) {
                        msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_description));
                    }
                    if (!msg.isEmpty()) {
                        msg.forEach(message -> box.getChildren().add(0, message));
                        return;
                    }
                    TransactionDataHolder transactionDataHolder = TransactionDataHolder.TransactionDataHolderBuilder.of((TransactionAction)StandardTransactionActions.INCOME, (EntityReference)gridConteiner.getSupplierNode().getValue(), (EntityReference)organization).date(DateUtils.asDate((LocalDateTime)gridConteiner.getDateNode().getValue())).amount(gridConteiner.getAmountNode().getValue()).description(gridConteiner.getDescriptionNode().getValue()).creditDimensionData().paymentType((PaymentType)gridConteiner.getPaymentTypeNode().getValue()).end().debitDimensionData().paymentType((PaymentType)gridConteiner.getPaymentTypeNode().getValue()).end().build();
                    Notifications.get().submitTask(() -> {
                        HashMap<String, TransactionDataHolder> data = new HashMap<String, TransactionDataHolder>();
                        data.put(IBusFinanceContextKeys.TRANSACTION_DATA_HOLDER.name(), transactionDataHolder);
                        ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "finance:create-custom-transaction", data);
                        callback.run();
                    }, Messages.Balance_editor_create_tranzaction);
                    dialog.close();
                }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)source);
            });
        }, Messages.Notifications_getting_data);
    }
}

