/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.dialog.MessagePane;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.DateTimeValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.PriceValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorPanel;
import com.gridnine.xtrip.client.fx.standard.balance.AddOperation;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerAction;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerPane;
import com.gridnine.xtrip.client.fx.standard.balance.DimensionWrapper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.DimensionType;
import com.gridnine.xtrip.common.model.finance.OperationType;
import com.gridnine.xtrip.common.model.finance.Transaction;
import com.gridnine.xtrip.common.model.finance.TransactionSplit;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.ModelHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SortOrder;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

public class AddTransactionBalanceEditorAction
implements BalanceEditorManagerAction {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_TRANSACTION.getId());
    private static final String EMPTY_UID = "empty";

    public ActionIcon getIcon(BalanceEditorManagerPane context) {
        return StandardActionIcons.ADD;
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isEnabled(BalanceEditorManagerPane context) {
        return context.getHeader() != null && context.getHeader().getOrganizationWidget().getValue() != null && !context.isChartOfAccountsSettingsDisabled();
    }

    public void execute(Control source, BalanceEditorManagerPane context, boolean alt) {
        EntityReference organization = context.getHeader().getOrganizationWidget().getValue();
        ComboBoxWidget<EntityReference<ChartOfAccountsElement>> accountWidget = context.getHeader().getAccountWidget();
        ComboBoxWidget typeWidget = new ComboBoxWidget(false);
        typeWidget.setNoNulls(true);
        typeWidget.setItemsSupplier(() -> {
            ArrayList<OperationType> list = new ArrayList<OperationType>();
            list.add(OperationType.CUSTOM_TRANSACTION);
            list.add(OperationType.REFILL);
            return list;
        });
        typeWidget.valueProperty().set((Object)OperationType.CUSTOM_TRANSACTION);
        new Dialog().setTitle(Messages.Choose_type_of_operation).setBody((Node)typeWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
            if (((OperationType)typeWidget.valueProperty().get()).equals((Object)OperationType.CUSTOM_TRANSACTION)) {
                this.createCustomOperation(context, source);
            } else {
                AddOperation.createRefillOperation((EntityReference<Organization>)organization, source, () -> {
                    if (accountWidget.getValue() == null) {
                        Notifications.get().submitTask(context::updateAccountWidget, Messages.Notifications_getting_data);
                    }
                    if (context.getBalanceEditorPanelSimpleContainer().getContent() != null) {
                        ((DataViewWidget)((BalanceEditorPanel)context.getBalanceEditorPanelSimpleContainer().getContent()).getTransactionsCard().getContent()).reloadData();
                    }
                });
            }
        }).show((Node)context);
    }

    private void createCustomOperation(BalanceEditorManagerPane context, Control source) {
        ComboBoxWidget<EntityReference<ChartOfAccountsElement>> billWidget = context.getHeader().getAccountWidget();
        EntityReference refChartOfAccountsElement = new EntityReference(EMPTY_UID, ChartOfAccountsElement.class, "");
        if (billWidget.getValue() != null) {
            EntityReference tempRef = (EntityReference)billWidget.getValue();
            refChartOfAccountsElement.setUid(tempRef.getUid());
            refChartOfAccountsElement.setCaption(tempRef.getCaption());
        }
        GridContainer gridContainer = new GridContainer();
        VBox box = new VBox(new Node[]{gridContainer});
        gridContainer.setColumnsCount(2);
        gridContainer.setAdaptive(true);
        EntityReference organizationReference = context.getHeader().getOrganizationWidget().getValue();
        GridCell<GridContainer> creditCell = this.createDebitOrCreditGridContainer(Messages.Credit, () -> refChartOfAccountsElement, (EntityReference<Organization>)organizationReference);
        gridContainer.getCells().add(creditCell);
        GridCell<GridContainer> debitCell = this.createDebitOrCreditGridContainer(Messages.Debit, () -> null, (EntityReference<Organization>)organizationReference);
        gridContainer.getCells().add(debitCell);
        GridContainer additionalGridContainer = new GridContainer();
        additionalGridContainer.setColumnsCount(3);
        PriceValueWidget amountWidget = new PriceValueWidget(false);
        additionalGridContainer.getCells().add((Object)new GridCell(Messages.Amount, (Node)amountWidget));
        DateTimeValueWidget dateTimeWidget = new DateTimeValueWidget(false);
        LocalDateTime startDateTime = LocalDate.now().atStartOfDay(ZoneId.systemDefault()).toLocalDateTime();
        dateTimeWidget.setValue(startDateTime);
        additionalGridContainer.getCells().add((Object)new GridCell(Messages.Date, (Node)dateTimeWidget));
        TextFieldWidget descriptionWidget = new TextFieldWidget(false);
        additionalGridContainer.getCells().add((Object)new GridCell(Messages.Description, (Node)descriptionWidget));
        GridCell additionalCell = new GridCell((Node)additionalGridContainer);
        additionalCell.setColSpan(2);
        gridContainer.getCells().add((Object)additionalCell);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Balance_editor_transaction).setAutoClose(false).setExpandToParent(true).setBody((Node)box).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_add, () -> {
            box.getChildren().removeAll((Collection)box.getChildren().stream().filter(node -> node.getClass() == MessagePane.class).collect(Collectors.toList()));
            ArrayList<MessagePane> msg = new ArrayList<MessagePane>();
            if (((EntityBoxWidget)((GridCell)((GridContainer)debitCell.getPayload()).getCells().get(0)).getPayload()).getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_debit));
            }
            if (((EntityBoxWidget)((GridCell)((GridContainer)creditCell.getPayload()).getCells().get(0)).getPayload()).getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_credit));
            }
            if (((PriceValueWidget)((GridCell)additionalGridContainer.getCells().get(0)).getPayload()).getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_amount));
            }
            if (((DateTimeValueWidget)((GridCell)additionalGridContainer.getCells().get(1)).getPayload()).getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_date));
            }
            if (((TextFieldWidget)((GridCell)additionalGridContainer.getCells().get(2)).getPayload()).getValue() == null) {
                msg.add(MessagePane.error((String)Messages.Action_transaction_balance_editor_not_filled_description));
            }
            if (!msg.isEmpty()) {
                msg.forEach(message -> box.getChildren().add(0, message));
                return;
            }
            TransactionSplit debitSplit = new TransactionSplit();
            debitSplit.setCredit(false);
            debitSplit.setAccount(((EntityBoxWidget)((GridCell)((GridContainer)debitCell.getPayload()).getCells().get(0)).getPayload()).getValue());
            debitSplit.setAmount(ModelHelper.bigDecimal2Long((BigDecimal)((BigDecimal)((PriceValueWidget)((GridCell)((GridContainer)((GridCell)gridContainer.getCells().get(2)).getPayload()).getCells().get(0)).getPayload()).getValue())));
            this.fillingTransactionSplitWithDimension(debitSplit, debitCell);
            TransactionSplit creditSplit = new TransactionSplit();
            creditSplit.setCredit(true);
            creditSplit.setAccount(((EntityBoxWidget)((GridCell)((GridContainer)creditCell.getPayload()).getCells().get(0)).getPayload()).getValue());
            creditSplit.setAmount(debitSplit.getAmount());
            this.fillingTransactionSplitWithDimension(creditSplit, creditCell);
            EntityContainer transactionContainer = new EntityContainer(Transaction.class);
            Transaction transaction = (Transaction)transactionContainer.getEntity();
            transaction.getSplits().clear();
            transaction.getSplits().add(debitSplit);
            transaction.getSplits().add(creditSplit);
            transaction.setOrganization(organizationReference);
            transaction.setOperationDate(DateUtils.asDate((LocalDateTime)((DateTimeValueWidget)((GridCell)additionalGridContainer.getCells().get(1)).getPayload()).getValue()));
            transaction.setDescription(((TextFieldWidget)((GridCell)additionalGridContainer.getCells().get(2)).getPayload()).getValue());
            Notifications.get().submitTask(() -> {
                ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).saveTransaction(ServiceInvocationContext.get(), transactionContainer);
                FxUtil.waitForFxThread(() -> ((DataViewWidget)((BalanceEditorPanel)context.getBalanceEditorPanelSimpleContainer().getContent()).getTransactionsCard().getContent()).reloadData());
            }, Messages.Add_transaction_balance_adding);
            dialog.close();
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).show((Node)source);
    }

    private void fillingTransactionSplitWithDimension(TransactionSplit split, GridCell<GridContainer> splitCell) {
        Object valueDimension3;
        DimensionWrapper dimensionWrapper3;
        Object valueDimension2;
        DimensionWrapper dimensionWrapper2;
        Object valueDimension1;
        DimensionWrapper dimensionWrapper1 = (DimensionWrapper)((GridContainer)splitCell.getPayload()).getProperties().get((Object)"dimensionWrapper1");
        if (dimensionWrapper1 != null && (valueDimension1 = dimensionWrapper1.getCategory().getValue(dimensionWrapper1.getWidget())) != null) {
            DimensionType type = dimensionWrapper1.getDimensionSettings().getType();
            String value = FinanceHelper.getDimensionValue((DimensionType)type, (Object)valueDimension1);
            split.setDimension1(value);
        }
        if ((dimensionWrapper2 = (DimensionWrapper)((GridContainer)splitCell.getPayload()).getProperties().get((Object)"dimensionWrapper2")) != null && (valueDimension2 = dimensionWrapper2.getCategory().getValue(dimensionWrapper2.getWidget())) != null) {
            DimensionType type = dimensionWrapper2.getDimensionSettings().getType();
            String value = FinanceHelper.getDimensionValue((DimensionType)type, (Object)valueDimension2);
            split.setDimension2(value);
        }
        if ((dimensionWrapper3 = (DimensionWrapper)((GridContainer)splitCell.getPayload()).getProperties().get((Object)"dimensionWrapper3")) != null && (valueDimension3 = dimensionWrapper3.getCategory().getValue(dimensionWrapper3.getWidget())) != null) {
            DimensionType type = dimensionWrapper3.getDimensionSettings().getType();
            String value = FinanceHelper.getDimensionValue((DimensionType)type, (Object)valueDimension3);
            split.setDimension3(value);
        }
    }

    private GridCell<GridContainer> createDebitOrCreditGridContainer(String caption, Supplier<EntityReference<ChartOfAccountsElement>> supplier, EntityReference<Organization> organizationReference) {
        GridContainer gridContainer = new GridContainer();
        gridContainer.setColumnsCount(1);
        EntityBoxWidget chartOfAccountsElementWidget = new EntityBoxWidget(ChartOfAccountsElement.class, false);
        chartOfAccountsElementWidget.setFieldName(Messages.Bill);
        chartOfAccountsElementWidget.setListParametersSupplier(() -> {
            IndexListParameters result = new IndexListParameters();
            result.setIndexType(ChartOfAccountsElementIndex.class);
            result.getSortings().put(ChartOfAccountsElementIndex.Property.organization.name(), SortOrder.ASC);
            result.getSearchCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), (Object)organizationReference));
            ListParametersHelper.setFilters(result, ChartOfAccountsElementIndex.Property.organization.name());
            ListParametersHelper.setColumns(result, ChartOfAccountsElementIndex.Property.organization.name(), ChartOfAccountsElementIndex.Property.type.name(), ChartOfAccountsElementIndex.Property.currency.name());
            return result;
        });
        chartOfAccountsElementWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            if (!gridContainer.getCells().isEmpty()) {
                GridCell tempCell = (GridCell)gridContainer.getCells().get(0);
                gridContainer.getCells().setAll((Object[])new GridCell[]{tempCell});
            }
            if (newValue != null) {
                Notifications.get().submitTask(() -> {
                    BasicChartOfAccountsElementSettings settings = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).loadAccountsElementSettings(ServiceInvocationContext.get(), newValue);
                    FxUtil.waitForFxThread(() -> {
                        if (settings == null) {
                            return;
                        }
                        if (settings.getDimension1() != null && settings.getDimension1().getType() != null) {
                            DimensionWrapper dimensionWrapper1 = new DimensionWrapper(settings.getDimension1());
                            dimensionWrapper1.setWidget(dimensionWrapper1.getCategory().createNode(dimensionWrapper1.getClazz()));
                            GridCell cell1 = new GridCell(dimensionWrapper1.getCaption(), dimensionWrapper1.getWidget());
                            gridContainer.getCells().add((Object)cell1);
                            gridContainer.getProperties().put((Object)"dimensionWrapper1", (Object)dimensionWrapper1);
                        }
                        if (settings.getDimension2() != null && settings.getDimension2().getType() != null) {
                            DimensionWrapper dimensionWrapper2 = new DimensionWrapper(settings.getDimension2());
                            dimensionWrapper2.setWidget(dimensionWrapper2.getCategory().createNode(dimensionWrapper2.getClazz()));
                            GridCell cell2 = new GridCell(dimensionWrapper2.getCaption(), dimensionWrapper2.getWidget());
                            gridContainer.getCells().add((Object)cell2);
                            gridContainer.getProperties().put((Object)"dimensionWrapper2", (Object)dimensionWrapper2);
                        }
                        if (settings.getDimension3() != null && settings.getDimension3().getType() != null) {
                            DimensionWrapper dimensionWrapper3 = new DimensionWrapper(settings.getDimension3());
                            dimensionWrapper3.setWidget(dimensionWrapper3.getCategory().createNode(dimensionWrapper3.getClazz()));
                            GridCell cell3 = new GridCell(dimensionWrapper3.getCaption(), dimensionWrapper3.getWidget());
                            gridContainer.getCells().add((Object)cell3);
                            gridContainer.getProperties().put((Object)"dimensionWrapper3", (Object)dimensionWrapper3);
                        }
                    });
                }, Messages.Notifications_getting_settings);
            }
        });
        if (supplier.get() != null && !EMPTY_UID.equals(supplier.get().getUid())) {
            FxUtil.submitToFxThread(() -> chartOfAccountsElementWidget.setValue((EntityReference)supplier.get()));
        }
        GridCell billCell = new GridCell((Node)chartOfAccountsElementWidget);
        billCell.setCaption(Messages.Bill);
        gridContainer.getCells().add((Object)billCell);
        GridCell cell = new GridCell((Node)gridContainer);
        cell.setCaption(caption);
        return cell;
    }

    public String getId() {
        return "balance-editor-add-transaction";
    }

    @Override
    public AclQuery getACLQuery(BalanceEditorManagerPane balanceEditorManagerPane) {
        return ACL_QUERY;
    }
}

