/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.action.ActionsPane;
import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomContextMenu;
import com.gridnine.xtrip.client.fx.core.lib.components.menu.CustomMenuItem;
import com.gridnine.xtrip.client.fx.core.lib.container.SimpleContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichContentWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.richcontent.RichData;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorFullPanel;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorPanel;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorFilterableDataViewHandler;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerAction;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerHeaderPane;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.finance.BasicChartOfAccountsElementSettings;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementIndex;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.profile.ContractIndex;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.Pane;

public class BalanceEditorManagerPane
extends BaseContentPane
implements DevTool {
    private BalanceEditorManagerHeaderPane header;
    private SimpleContainer<BalanceEditorPanel> balanceEditorPanelSimpleContainer;
    private boolean chartOfAccountsSettingsDisabled = true;
    private final Map<EntityReference<ChartOfAccountsElement>, BalanceEditorPanel> storageBalanceEditorPanel = new HashMap<EntityReference<ChartOfAccountsElement>, BalanceEditorPanel>();
    private final Set<String> actionsAcl = new HashSet<String>();
    private final ActionsPane<BalanceEditorManagerAction> actionsPane = new ActionsPane<BalanceEditorManagerAction>(){

        protected void execute(Control source, BalanceEditorManagerAction action, boolean alt) {
            action.execute(source, (Object)BalanceEditorManagerPane.this, alt);
        }

        protected boolean isDefault(BalanceEditorManagerAction action) {
            return false;
        }

        protected boolean isEnabled(BalanceEditorManagerAction action) {
            if (!BalanceEditorManagerPane.this.actionsAcl.contains(action.getId())) {
                return false;
            }
            return action.isEnabled((Object)BalanceEditorManagerPane.this);
        }

        protected String getName(BalanceEditorManagerAction action) {
            return action.getName(BalanceEditorManagerPane.this);
        }

        protected String getDescription(BalanceEditorManagerAction action) {
            return action.getDescription(BalanceEditorManagerPane.this);
        }

        protected ActionIcon getIcon(BalanceEditorManagerAction action) {
            return action.getIcon((Object)BalanceEditorManagerPane.this);
        }
    };

    BalanceEditorManagerPane() {
        Notifications.get().submitTask(() -> {
            this.reloadActionsACL();
            FxUtil.waitForFxThread(() -> {
                this.getStyleClass().add((Object)"xtrip-editor-pane");
                this.balanceEditorPanelSimpleContainer = new SimpleContainer();
                this.actionsPane.populate(this.getAvailableActions());
                this.composePane((Node)this.balanceEditorPanelSimpleContainer, (Node)this.buildHeader(), (ActionsPane)this.actionsPane, null);
            });
        }, Messages.Notifications_getting_settings);
    }

    private void reloadActionsACL() throws Exception {
        HashSet<String> enabled = new HashSet<String>();
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (BalanceEditorManagerAction action : this.getAvailableActions()) {
            AclQuery query = action.getACLQuery(this);
            if (query == null) {
                enabled.add(action.getId());
                continue;
            }
            map.put(action.getId(), query);
        }
        Set granted = FxAclUtil.applyACL(map);
        this.actionsAcl.clear();
        this.actionsAcl.addAll(enabled);
        this.actionsAcl.addAll(granted);
    }

    private List<BalanceEditorManagerAction> getAvailableActions() {
        return ClientRegistry.get().allOf(BalanceEditorManagerAction.TYPE).values().stream().filter(action -> action.isAvailable((Object)this)).collect(Collectors.toList());
    }

    private BalanceEditorManagerHeaderPane buildHeader() {
        this.header = new BalanceEditorManagerHeaderPane();
        EntityBoxWidget<Organization> organizationWidget = this.header.getOrganizationWidget();
        ComboBoxWidget<EntityReference<ChartOfAccountsElement>> accountWidget = this.header.getAccountWidget();
        Label emptyAccountCaption = this.header.getEmptyAccountCaption();
        emptyAccountCaption.setText(Messages.Balance_editor_manager_pane_empty_value_bill);
        organizationWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            if (newValue == null) {
                emptyAccountCaption.setText(Messages.Balance_editor_manager_pane_empty_value_bill);
                this.actionsPane.revalidate();
            } else {
                Notifications.get().submitTask(this::updateAccountWidget, Messages.Notifications_getting_data);
            }
        });
        accountWidget.valueProperty().addListener((obj, oldValue, newValue) -> {
            this.actionsPane.revalidate();
            if (newValue != null) {
                if (this.storageBalanceEditorPanel.get(newValue) != null) {
                    this.balanceEditorPanelSimpleContainer.setContent((Node)this.storageBalanceEditorPanel.get(newValue));
                } else {
                    BalanceEditorPanel balanceEditorPanel = this.createBalanceEditorPanel((EntityReference<ChartOfAccountsElement>)newValue);
                    this.balanceEditorPanelSimpleContainer.setContent((Node)balanceEditorPanel);
                    this.storageBalanceEditorPanel.put((EntityReference<ChartOfAccountsElement>)newValue, balanceEditorPanel);
                }
            } else {
                this.balanceEditorPanelSimpleContainer.setContent(null);
            }
        });
        this.header.setOnMouseClicked(evt -> {
            if (!evt.isAltDown() || evt.getButton() != MouseButton.PRIMARY) {
                return;
            }
            CustomContextMenu menu = new CustomContextMenu();
            menu.getItems().addAll(this.collectAdminTools());
            menu.show((Node)this.header, evt.getScreenX(), evt.getScreenY());
        });
        return this.header;
    }

    private List<MenuItem> collectAdminTools() {
        CustomMenuItem item;
        ArrayList<MenuItem> result = new ArrayList<MenuItem>();
        if (this.header.getAccountWidget().getValue() != null) {
            item = new CustomMenuItem("Account Container Data");
            item.setOnAction(evt -> Notifications.get().submitTask(() -> {
                EntityContainer chartOfAccountsElement = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), (EntityReference)this.header.getAccountWidget().getValue());
                FxUtil.waitForFxThread(() -> {
                    try {
                        RichContentWidget widget = new RichContentWidget(true);
                        widget.setFileNameSupplier(() -> chartOfAccountsElement.getUid() + ".xml");
                        RichData rd = new RichData();
                        rd.setContentType(ContentType.XML);
                        rd.setContent(XSUtil.toByteArray((XSSerializable)chartOfAccountsElement));
                        widget.setData(rd);
                        widget.getViewState().setNotEditable(true);
                        new Dialog().setTitle("Entity Container Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                });
            }, Messages.Notifications_getting_data));
            result.add((MenuItem)item);
        }
        item = new CustomMenuItem("UI Technical Data");
        item.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(this.buildTechData());
            widget.setMonospace(true);
            widget.getViewState().setNotEditable(true);
            new Dialog().setTitle("Balance Editor UI Technicalt Data").setBody((Node)widget).addButton(DialogButtonStyle.DECLINE, "Close").setExpandToParent(true).show((Node)this);
        });
        result.add((MenuItem)item);
        return result;
    }

    private String buildTechData() {
        StringBuilder result = new StringBuilder();
        result.append("Actions (class, ID, title [flags])\n");
        for (BalanceEditorManagerAction action : this.getAvailableActions()) {
            result.append(action.getClass().getName()).append('\t').append(action.getId()).append('\t').append(action.getName(this));
            if (!action.isEnabled((Object)this)) {
                result.append(" [disabled]");
            }
            if (!this.actionsAcl.contains(action.getId())) {
                result.append(" [forbidden]");
            }
            result.append('\n');
        }
        result.append('\n');
        result.append(DevTools.getStructuredInfo((Object)((Object)this)));
        return result.toString();
    }

    void updateAccountWidget() throws Exception {
        EntityReference organization = this.header.getOrganizationWidget().getValue();
        ComboBoxWidget<EntityReference<ChartOfAccountsElement>> accountWidget = this.header.getAccountWidget();
        Label emptyAccountCaption = this.header.getEmptyAccountCaption();
        List<EntityReference<ChartOfAccountsElement>> accountWidgetItems = this.getChartOfAccountsElements((EntityReference<Organization>)organization);
        this.chartOfAccountsSettingsDisabled = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).isChartOfAccountsSettingsDisabled(ServiceInvocationContext.get(), organization);
        FxUtil.waitForFxThread(() -> {
            accountWidget.setItemsSupplier(() -> accountWidgetItems);
            if (!accountWidgetItems.isEmpty()) {
                accountWidget.setValue(accountWidgetItems.get(0));
            } else {
                emptyAccountCaption.setText(Messages.Balance_editor_manager_pane_bill_not_found);
            }
            this.actionsPane.revalidate();
        });
    }

    private List<EntityReference<ChartOfAccountsElement>> getChartOfAccountsElements(EntityReference<Organization> organization) throws Exception {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ChartOfAccountsElementIndex.Property.organization.name(), organization));
        List chartOfAccountsElementIndexes = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), ChartOfAccountsElementIndex.class, query);
        return chartOfAccountsElementIndexes.stream().filter(index -> index.getType() != null && index.getCurrency() != null).filter(index -> !FinanceHelper.isSpecialChartOfAccountsElementType((ChartOfAccountsElementType)index.getType())).sorted(Comparator.comparing(ChartOfAccountsElementIndex::isDisabled).thenComparing(Object::toString)).map(ChartOfAccountsElementIndex::getSource).collect(Collectors.toList());
    }

    public boolean isChartOfAccountsSettingsDisabled() {
        return this.chartOfAccountsSettingsDisabled;
    }

    BalanceEditorManagerHeaderPane getHeader() {
        return this.header;
    }

    SimpleContainer<BalanceEditorPanel> getBalanceEditorPanelSimpleContainer() {
        return this.balanceEditorPanelSimpleContainer;
    }

    private BalanceEditorPanel createBalanceEditorPanel(EntityReference<ChartOfAccountsElement> refChartOfAccountsElement) {
        BalanceEditorPanel resultPanel = new BalanceEditorPanel(false);
        resultPanel.getTransactionsCard().setAdaptiveHeight(true);
        DataViewWidget dataWidget = (DataViewWidget)resultPanel.getTransactionsCard().getContent();
        dataWidget.getTableView().getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        BalanceEditorFullPanel balanceEditorFullPanel = new BalanceEditorFullPanel(false);
        Notifications.get().submitTask(() -> {
            BasicChartOfAccountsElementSettings settings = ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).loadAccountsElementSettings(ServiceInvocationContext.get(), refChartOfAccountsElement);
            EntityReference organization = this.header.getOrganizationWidget().getValue();
            SearchQuery query = new SearchQuery();
            query.getPreferredProperties().add(ContractIndex.Property.supplier.name());
            query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractIndex.Property.customer.name(), (Object)organization));
            List suppliers = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), ContractIndex.class, query).stream().map(ContractIndex::getSupplier).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            EntityReference defaultSupplier = suppliers.size() == 1 ? (EntityReference)suppliers.get(0) : null;
            FxUtil.waitForFxThread(() -> {
                BalanceEditorFilterableDataViewHandler handler = new BalanceEditorFilterableDataViewHandler(refChartOfAccountsElement, balanceEditorFullPanel, dataWidget.getTableView().getColumns(), settings, (EntityReference<Organization>)defaultSupplier);
                dataWidget.setHandler((DataViewHandler)handler);
                dataWidget.getAdditionalPanesContainer().getChildren().add((Object)balanceEditorFullPanel);
                dataWidget.reloadData();
            });
        }, Messages.Notifications_getting_settings);
        ((DataViewWidget)resultPanel.getTransactionsCard().getContent()).setDefaultActionHandler(() -> {
            for (BalanceEditorManagerAction action : this.getAvailableActions()) {
                if (!"balance-editor-edit-transaction".equals(action.getId())) continue;
                if (!action.isEnabled((Object)this)) break;
                action.execute((Control)((DataViewWidget)resultPanel.getTransactionsCard().getContent()).getTableView(), (Object)this, false);
                break;
            }
        });
        ((DataViewWidget)resultPanel.getTransactionsCard().getContent()).getTableView().getSortOrder().clear();
        return resultPanel;
    }

    public void dispose() {
        super.dispose();
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (BalanceEditorManagerPane.this.balanceEditorPanelSimpleContainer.getContent() != null) {
                    return Arrays.asList(new Pane[]{BalanceEditorManagerPane.this.header, (Pane)BalanceEditorManagerPane.this.balanceEditorPanelSimpleContainer.getContent()});
                }
                return Collections.singleton(BalanceEditorManagerPane.this.header);
            }

            public String getInfo() {
                return ((Object)((Object)BalanceEditorManagerPane.this)).getClass().getSimpleName();
            }
        };
    }
}

