/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dataview.DataViewWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.profile.BalanceDataVM;
import com.gridnine.xtrip.client.fx.model.profile.BalanceEditorPanel;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerAction;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerPane;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.EntityDeleteTask;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.FinanceService;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class DeleteTransactionBalanceEditorAction
implements BalanceEditorManagerAction {
    private static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.DELETE.getId(), ModelRestrictionEntityResources.ENTITY_TRANSACTION.getId());

    public ActionIcon getIcon(BalanceEditorManagerPane context) {
        return StandardActionIcons.DELETE;
    }

    public double getWeight() {
        return 30.0;
    }

    public boolean isEnabled(BalanceEditorManagerPane context) {
        return context.getHeader() != null && context.getHeader().getAccountWidget().getValue() != null;
    }

    public void execute(Control source, BalanceEditorManagerPane context, boolean alt) {
        ObservableList balanceDataVMList = ((DataViewWidget)((BalanceEditorPanel)context.getBalanceEditorPanelSimpleContainer().getContent()).getTransactionsCard().getContent()).getTableView().getSelectionModel().getSelectedItems();
        if (balanceDataVMList.size() > 0) {
            if (!alt) {
                Dialog.confirm((Node)context, (String)Messages.Dialog_confirm_deletion, () -> Notifications.get().submitTask(() -> {
                    ((FinanceService)RpcServiceManager.get().getService(FinanceService.class)).deleteTransaction(ServiceInvocationContext.get(), balanceDataVMList.stream().map(BalanceDataVM::getTransactionReference).collect(Collectors.toList()));
                    FxUtil.waitForFxThread(() -> ((DataViewWidget)((BalanceEditorPanel)context.getBalanceEditorPanelSimpleContainer().getContent()).getTransactionsCard().getContent()).reloadData());
                }, Messages.Notifications_delete_data));
            } else {
                Dialog.confirm((Node)context, (String)Messages.Dialog_Confirm_Delete_Forever, null, (String)Messages.Delete_Forever, () -> {
                    Notifications.get().enqueueAsyncTask((ClientTask)new EntityDeleteTask(balanceDataVMList.stream().map(BalanceDataVM::getTransactionReference).collect(Collectors.toList())));
                    Notifications.get().submitTask(() -> FxUtil.waitForFxThread(() -> ((DataViewWidget)((BalanceEditorPanel)context.getBalanceEditorPanelSimpleContainer().getContent()).getTransactionsCard().getContent()).reloadData()), Messages.Notifications_delete_data);
                }, null);
            }
        } else {
            Dialog.info((Node)source, (String)Messages.Delete_transaction_balance_editor_transaction_not_selected);
        }
    }

    public String getId() {
        return "balance-editor-delete-transaction";
    }

    @Override
    public AclQuery getACLQuery(BalanceEditorManagerPane balanceEditorManagerPane) {
        return ACL_QUERY;
    }
}

