/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.balance;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.DictBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.BooleanValueWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerAction;
import com.gridnine.xtrip.client.fx.standard.balance.BalanceEditorManagerPane;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElement;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsElementType;
import com.gridnine.xtrip.common.model.finance.ChartOfAccountsSettings;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Locale;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;

public class EditChartOfAccountsElementBalanceEditor
implements BalanceEditorManagerAction {
    @Override
    public AclQuery getACLQuery(BalanceEditorManagerPane balanceEditorManagerPane) {
        return new AclQuery(StandardRestrictionResourceOperations.EDIT.getId(), ModelRestrictionEntityResources.ENTITY_CHART_OF_ACCOUNTS_SETTINGS.getId());
    }

    public ActionIcon getIcon(BalanceEditorManagerPane context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 41.0;
    }

    public boolean isEnabled(BalanceEditorManagerPane context) {
        return context.getHeader() != null && context.getHeader().getOrganizationWidget().getValue() != null && context.getHeader().getAccountWidget().getValue() != null;
    }

    public void execute(Control source, BalanceEditorManagerPane context, boolean alt) {
        EntityReference accountRef = (EntityReference)context.getHeader().getAccountWidget().getValue();
        Notifications.get().submitTask(() -> {
            EntityContainer accountCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), accountRef);
            if (accountCtr != null) {
                ChartOfAccountsElementType type = ((ChartOfAccountsElement)accountCtr.getEntity()).getType();
                EntityReference settings = ((ChartOfAccountsElement)accountCtr.getEntity()).getSettings();
                EntityReference organization = ((ChartOfAccountsElement)accountCtr.getEntity()).getOrganization();
                DictionaryReference currency = ((ChartOfAccountsElement)accountCtr.getEntity()).getCurrency();
                boolean disabled = ((ChartOfAccountsElement)accountCtr.getEntity()).isDisabled();
                FxUtil.waitForFxThread(() -> {
                    GridContainer gridContainer = new GridContainer();
                    VBox box = new VBox(new Node[]{gridContainer});
                    gridContainer.setColumnsCount(2);
                    gridContainer.setAdaptive(true);
                    TextFieldWidget typeWidget = new TextFieldWidget(true);
                    EntityBoxWidget settingsWidget = new EntityBoxWidget(ChartOfAccountsSettings.class, true);
                    EntityBoxWidget organizationWidget = new EntityBoxWidget(Organization.class, true);
                    DictBoxWidget currencyWidget = new DictBoxWidget(CurrencyInfo.class, true);
                    BooleanValueWidget disableWidget = new BooleanValueWidget(false, false);
                    typeWidget.setValue(LocaleHelper.toString((Object)type, (Locale)LocaleHelper.getCurrentLocale()));
                    settingsWidget.setValue(settings);
                    organizationWidget.setValue(organization);
                    currencyWidget.setValue(currency);
                    disableWidget.setValue(disabled);
                    GridCell typeCell = new GridCell(Messages.Type, (Node)typeWidget);
                    GridCell settingsCell = new GridCell(Messages.ChartOfAccountsSettings, (Node)settingsWidget);
                    GridCell organizationCell = new GridCell(Messages.Organization, (Node)organizationWidget);
                    GridCell currencyCell = new GridCell(Messages.Currency, (Node)currencyWidget);
                    GridCell disableCell = new GridCell(Messages.Inactive, (Node)disableWidget);
                    gridContainer.getCells().addAll((Object[])new GridCell[]{typeCell, settingsCell, organizationCell, currencyCell, disableCell});
                    Dialog dialog = new Dialog();
                    dialog.setTitle(Messages.Balance_editor_transaction).setAutoClose(true).setExpandToParent(false).setBody((Node)box).addButton(DialogButtonStyle.DECLINE, () -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Dialog_save, () -> {
                        if (((ChartOfAccountsElement)accountCtr.getEntity()).isDisabled() != disableWidget.getValue()) {
                            ((ChartOfAccountsElement)accountCtr.getEntity()).setDisabled(disableWidget.getValue());
                            Notifications.get().submitTask(() -> ((EntityService)RpcServiceManager.get().getService(EntityService.class)).save(ServiceInvocationContext.get(), accountCtr, null, true), Messages.Notifications_saving_data);
                        }
                    });
                    dialog.show((Node)context);
                });
            }
        }, Messages.Notifications_getting_data);
    }

    public String getId() {
        return "balance-editor-edit-chartOfAccountsElement";
    }
}

