/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.EntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.MoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.RateMoneyValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multitable.MultiTableRowEvent;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multitable.MultiTableWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.ComboBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.EntityBoxWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.MoneyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.column.dialog.RateMoneyValueWidgetColumn;
import com.gridnine.xtrip.client.fx.core.util.MultiProvider;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionItemVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsEntryVM;
import com.gridnine.xtrip.client.fx.model.custom.commissions.CommissionsWidgetVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.AirProductFXHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.DiscountPropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.FeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.PaymentFeePropertiesIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.util.StringConverter;

public class CommissionsWidget2
extends CustomWidget<CommissionsWidgetVM>
implements DevTool {
    private static final String FAKE_BSP_COMMISSION_UID = "fake_bsp";
    public static final String commissionsId = "commission";
    public static final String feesId = "fees";
    protected ProductDataSupplier productDataSupplier = new ProductDataSupplier(){

        @Override
        public ProductType getProductType() {
            return null;
        }

        @Override
        public List<SegmentTariff> getSegmentTariffs() {
            return Collections.emptyList();
        }

        @Override
        public boolean isUseSegmentColumn() {
            return false;
        }
    };
    protected MultiTableWidget.MultiTableHandler<CommissionsWidgetVM, CommissionsEntryVM> handler = new MultiTableWidget.MultiTableHandler<CommissionsWidgetVM, CommissionsEntryVM>(){

        public List<MultiTableWidget.TableHandler<CommissionsEntryVM, ?>> getHandlers() {
            MultiTableWidget.TableHandler<CommissionsEntryVM, CommissionItemVM> commissionsHandler = new MultiTableWidget.TableHandler<CommissionsEntryVM, CommissionItemVM>(){

                public String getId() {
                    return CommissionsWidget2.commissionsId;
                }

                public List<TableWidgetColumn<CommissionItemVM, ?>> getColumns() {
                    ArrayList columns = new ArrayList();
                    if (CommissionsWidget2.this.productDataSupplier.isUseSegmentColumn()) {
                        ComboBoxWidgetColumn segmentColumn = new ComboBoxWidgetColumn(item -> item.getSegmentTariff(), (item, value) -> item.setSegmentTariff(value));
                        segmentColumn.setCaption(Messages.Segment);
                        segmentColumn.setId("segment");
                        segmentColumn.setNotHGrowable(true);
                        segmentColumn.setConverter((StringConverter)new StringConverter<SegmentTariff>(){

                            public String toString(SegmentTariff value) {
                                return AirProductFXHelper.getSegmentsDataDescription(value);
                            }

                            public SegmentTariff fromString(String value) {
                                return null;
                            }
                        });
                        segmentColumn.setItemsSupplier(() -> CommissionsWidget2.this.productDataSupplier.getSegmentTariffs());
                        columns.add((TableWidgetColumn<CommissionItemVM, ?>)segmentColumn);
                    }
                    EntityBoxWidgetColumn propertiesColumn = new EntityBoxWidgetColumn(BaseCommissionProperties.class, item -> item.getCommissionProperties(), (item, value) -> item.setCommissionProperties(value));
                    propertiesColumn.setCaption(Messages.Name);
                    propertiesColumn.setId("properties");
                    propertiesColumn.setListParametersSupplier(new MultiSupplier<IndexListParameters<BaseCommissionProperties, ?>>(){
                        Supplier<List<IndexListParameters<? extends BaseCommissionProperties, ? extends EntityIndex<? extends BaseCommissionProperties>>>> parameters = () -> {
                            IndexListParameters commissionIndexParameters = EntityIndexHandler.forIndexClass(CommissionPropertiesIndex.class).createListParameters();
                            ProductType productType = CommissionsWidget2.this.productDataSupplier.getProductType();
                            if (productType != null) {
                                commissionIndexParameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)CommissionPropertiesIndex.Property.productTypes.name(), (Object)productType), SearchCriterion.isEmpty((String)CommissionPropertiesIndex.Property.productTypes.name())}));
                            }
                            IndexListParameters discountIndexParameters = EntityIndexHandler.forIndexClass(DiscountPropertiesIndex.class).createListParameters();
                            return Arrays.asList(commissionIndexParameters, discountIndexParameters);
                        };

                        public String getDisplayName(int index) {
                            return MetaRegistryHelper.getDisplayName((Class)this.parameters.get().get(index).getIndexType());
                        }

                        public IndexListParameters<BaseCommissionProperties, ?> get(int index) {
                            return this.parameters.get().get(index);
                        }

                        public int count() {
                            return this.parameters.get().size();
                        }
                    });
                    columns.add((TableWidgetColumn<CommissionItemVM, ?>)propertiesColumn);
                    RateMoneyValueWidgetColumn valueColumn = new RateMoneyValueWidgetColumn(item -> item.getValue(), (item, value) -> item.setValue(value));
                    valueColumn.setCaption(Messages.Rate);
                    valueColumn.setId("value");
                    valueColumn.setNotHGrowable(true);
                    columns.add((TableWidgetColumn<CommissionItemVM, ?>)valueColumn);
                    MoneyValueWidgetColumn amountColumn = new MoneyValueWidgetColumn(item -> item.getSum(), (item, value) -> item.setSum(value));
                    amountColumn.setCaption(Messages.Amount);
                    amountColumn.setId("sum");
                    amountColumn.setNotHGrowable(true);
                    amountColumn.setFixedCurrency(true);
                    columns.add((TableWidgetColumn<CommissionItemVM, ?>)amountColumn);
                    return columns;
                }

                public List<CommissionItemVM> getRows(CommissionsEntryVM tableSet) {
                    return tableSet.getCommissions();
                }

                public void setRows(CommissionsEntryVM tableSet, List<CommissionItemVM> rows) {
                    tableSet.getCommissions().clear();
                    tableSet.getCommissions().addAll(rows);
                }

                public MultiProvider<CommissionItemVM> getItemsProvider() {
                    return () -> {
                        CommissionItemVM item = new CommissionItemVM();
                        item.setUid(UUID.randomUUID().toString());
                        return item;
                    };
                }

                public Predicate<ControlsPane.ButtonType> getControlButtonsAvailability() {
                    return ControlsPane.ADD_REMOVE;
                }

                public String getTitle(CommissionsEntryVM tableSet) {
                    return Messages.Commission + " " + tableSet.getContractType();
                }

                public Node createSummaryNode() {
                    return new MoneyValueWidget(true);
                }
            };
            MultiTableWidget.TableHandler<CommissionsEntryVM, CommissionItemVM> feesHandler = new MultiTableWidget.TableHandler<CommissionsEntryVM, CommissionItemVM>(){

                public String getId() {
                    return CommissionsWidget2.feesId;
                }

                public List<TableWidgetColumn<CommissionItemVM, ?>> getColumns() {
                    ArrayList columns = new ArrayList();
                    if (CommissionsWidget2.this.productDataSupplier.isUseSegmentColumn()) {
                        ComboBoxWidgetColumn segmentColumn = new ComboBoxWidgetColumn(item -> item.getSegmentTariff(), (item, value) -> item.setSegmentTariff(value));
                        segmentColumn.setCaption(Messages.Segment);
                        segmentColumn.setId("segment");
                        segmentColumn.setNotHGrowable(true);
                        segmentColumn.setConverter((StringConverter)new StringConverter<SegmentTariff>(){

                            public String toString(SegmentTariff value) {
                                return AirProductFXHelper.getSegmentsDataDescription(value);
                            }

                            public SegmentTariff fromString(String value) {
                                return null;
                            }
                        });
                        segmentColumn.setItemsSupplier(() -> CommissionsWidget2.this.productDataSupplier.getSegmentTariffs());
                        columns.add((TableWidgetColumn<CommissionItemVM, ?>)segmentColumn);
                    }
                    EntityBoxWidgetColumn propertiesColumn = new EntityBoxWidgetColumn(BaseCommissionProperties.class, item -> item.getCommissionProperties(), (item, value) -> item.setCommissionProperties(value));
                    propertiesColumn.setCaption(Messages.Name);
                    propertiesColumn.setId("properties");
                    propertiesColumn.setListParametersSupplier(new MultiSupplier<IndexListParameters<BaseCommissionProperties, ?>>(){
                        Supplier<List<IndexListParameters<? extends BaseCommissionProperties, ? extends EntityIndex<? extends BaseCommissionProperties>>>> parameters = () -> {
                            IndexListParameters serviceFeeIndexParameters = EntityIndexHandler.forIndexClass(FeePropertiesIndex.class).createListParameters();
                            ProductType productType = CommissionsWidget2.this.productDataSupplier.getProductType();
                            if (productType != null) {
                                serviceFeeIndexParameters.getSearchCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.contains((String)FeePropertiesIndex.Property.productTypes.name(), (Object)productType), SearchCriterion.isEmpty((String)FeePropertiesIndex.Property.productTypes.name())}));
                            }
                            IndexListParameters paymentFeeIndexParameters = EntityIndexHandler.forIndexClass(PaymentFeePropertiesIndex.class).createListParameters();
                            return Arrays.asList(serviceFeeIndexParameters, paymentFeeIndexParameters);
                        };

                        public String getDisplayName(int index) {
                            return MetaRegistryHelper.getDisplayName((Class)this.parameters.get().get(index).getIndexType());
                        }

                        public IndexListParameters<BaseCommissionProperties, EntityIndex<BaseCommissionProperties>> get(int index) {
                            return this.parameters.get().get(index);
                        }

                        public int count() {
                            return this.parameters.get().size();
                        }
                    });
                    columns.add((TableWidgetColumn<CommissionItemVM, ?>)propertiesColumn);
                    RateMoneyValueWidgetColumn valueColumn = new RateMoneyValueWidgetColumn(item -> item.getValue(), (item, value) -> item.setValue(value));
                    valueColumn.setCaption(Messages.Rate);
                    valueColumn.setId("value");
                    valueColumn.setNotHGrowable(true);
                    columns.add((TableWidgetColumn<CommissionItemVM, ?>)valueColumn);
                    MoneyValueWidgetColumn amountColumn = new MoneyValueWidgetColumn(item -> item.getSum(), (item, value) -> item.setSum(value));
                    amountColumn.setCaption(Messages.Amount);
                    amountColumn.setId("sum");
                    amountColumn.setNotHGrowable(true);
                    amountColumn.setFixedCurrency(true);
                    columns.add((TableWidgetColumn<CommissionItemVM, ?>)amountColumn);
                    return columns;
                }

                public List<CommissionItemVM> getRows(CommissionsEntryVM tableSet) {
                    return tableSet.getFees();
                }

                public void setRows(CommissionsEntryVM tableSet, List<CommissionItemVM> rows) {
                    tableSet.getFees().clear();
                    tableSet.getFees().addAll(rows);
                }

                public MultiProvider<CommissionItemVM> getItemsProvider() {
                    return () -> {
                        CommissionItemVM item = new CommissionItemVM();
                        item.setUid(UUID.randomUUID().toString());
                        return item;
                    };
                }

                public Predicate<ControlsPane.ButtonType> getControlButtonsAvailability() {
                    return ControlsPane.ADD_REMOVE;
                }

                public String getTitle(CommissionsEntryVM tableSet) {
                    return Messages.Fees + " " + tableSet.getContractType();
                }

                public Node createSummaryNode() {
                    return new MoneyValueWidget(true);
                }
            };
            return Arrays.asList(commissionsHandler, feesHandler);
        }

        public List<CommissionsEntryVM> getTableSets(CommissionsWidgetVM data) {
            return data.getEntries();
        }

        public void setTableSets(CommissionsWidgetVM data, List<CommissionsEntryVM> tableSets) {
            data.getEntries().clear();
            data.getEntries().addAll(tableSets);
        }

        public EventHandler<MultiTableRowEvent> createEventHandler() {
            return event -> {
                MultiTableWidget multiTableWidget = (MultiTableWidget)event.getSource();
                MultiTableWidget.Row row = event.getRow();
                MoneyValueWidget summaryWidget = (MoneyValueWidget)row.getTable().getSummaryNode();
                if (event.getEventType() == MultiTableRowEvent.ROW_ADD) {
                    EntityBoxWidget propertiesWidget;
                    if (MiscUtil.equals((Object)row.getId(), (Object)CommissionsWidget2.FAKE_BSP_COMMISSION_UID) && (propertiesWidget = (EntityBoxWidget)row.getWidget("properties")) != null) {
                        propertiesWidget.setInactive(true);
                        propertiesWidget.getViewState().setNotEditable(true);
                    }
                    RateMoneyValueWidget valueWidget = (RateMoneyValueWidget)row.getWidget("value");
                    MoneyValueWidget amountWidget = (MoneyValueWidget)row.getWidget("sum");
                    if (valueWidget != null && amountWidget != null) {
                        valueWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                            boolean processing = Optional.ofNullable(multiTableWidget.getProperties().get((Object)row.getId())).map(item -> (Boolean)item).orElse(Boolean.FALSE);
                            if (!processing) {
                                try {
                                    multiTableWidget.getProperties().put((Object)row.getId(), (Object)Boolean.TRUE);
                                    String valueCurrency = Optional.ofNullable(valueWidget.getValue()).map(item -> item.getMoney()).map(item -> item.getCurrency()).orElse(null);
                                    String amountCurrency = Optional.ofNullable(amountWidget.getValue()).map(item -> item.getCurrency()).orElse(null);
                                    if (MiscUtil.equals((Object)valueCurrency, (Object)amountCurrency) || amountCurrency == null) {
                                        amountWidget.setValue((Money)Optional.ofNullable(valueWidget.getValue()).map(item -> item.getMoney()).orElse(null));
                                    }
                                }
                                finally {
                                    multiTableWidget.getProperties().remove((Object)row.getId());
                                }
                            }
                        });
                        amountWidget.valueProperty().addListener((observable, oldValue, newValue) -> {
                            boolean processing = Optional.ofNullable(multiTableWidget.getProperties().get((Object)row.getId())).map(item -> (Boolean)item).orElse(Boolean.FALSE);
                            if (!processing) {
                                try {
                                    multiTableWidget.getProperties().put((Object)row.getId(), (Object)Boolean.TRUE);
                                    String amountCurrency = Optional.ofNullable(amountWidget.getValue()).map(item -> item.getCurrency()).orElse(null);
                                    String valueCurrency = Optional.ofNullable(valueWidget.getValue()).map(item -> item.getMoney()).map(item -> item.getCurrency()).orElse(null);
                                    if (MiscUtil.equals((Object)amountCurrency, (Object)valueCurrency)) {
                                        RateMoney rateMoney = new RateMoney();
                                        rateMoney.setMoney((Money)Optional.ofNullable(amountWidget.getValue()).orElse(null));
                                        valueWidget.setValue(rateMoney);
                                    }
                                }
                                finally {
                                    multiTableWidget.getProperties().remove((Object)row.getId());
                                }
                            }
                        });
                    }
                    if (amountWidget != null) {
                        amountWidget.valueProperty().addListener((observable, oldValue, newValue) -> this.updateSummary(row, summaryWidget));
                    }
                } else {
                    this.updateSummary(row, summaryWidget);
                }
            };
        }

        private void updateSummary(MultiTableWidget.Row<?, ?, ?> row, MoneyValueWidget summaryWidget) {
            Map<Boolean, List<MoneyValueWidget>> widgets = row.getTable().getRows().stream().map(item -> (MoneyValueWidget)item.getWidget("sum")).filter(item -> item != null).collect(Collectors.partitioningBy(item -> item.isVisible()));
            if (widgets.get(Boolean.FALSE).size() == 0) {
                String currency = widgets.get(Boolean.TRUE).stream().map(MoneyValueWidget::getValue).filter(Objects::nonNull).map(Money::getCurrency).filter(Objects::nonNull).findFirst().orElse(Prefetched.getData().getEquivalentCurrency());
                BigDecimal amount = widgets.get(Boolean.TRUE).stream().filter(item -> item.getValue() != null && item.getValue().getValue() != null).map(item -> item.getValue().getValue()).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
                summaryWidget.setValue(amount != null ? SystemHelper.getMoney((BigDecimal)amount, (String)currency) : null);
            } else {
                summaryWidget.setValue(null);
            }
        }
    };
    private MultiTableWidget<CommissionsWidgetVM, CommissionsEntryVM> table;

    public CommissionsWidget2(boolean readonly) {
        this.createGUI(readonly);
        this.createBindings();
        this.createListeners();
    }

    private void createGUI(boolean readonly) {
        this.table = new MultiTableWidget(readonly);
        this.table.setHandler(this.handler);
        this.getChildren().setAll((Object[])new Node[]{this.table});
    }

    private void createBindings() {
    }

    private void createListeners() {
    }

    public ViewState getViewState() {
        return this.table.getViewState();
    }

    public void setFieldName(String value) {
    }

    public void setProductDataSupplier(ProductDataSupplier productDataSupplier) {
        this.productDataSupplier = Objects.requireNonNull(productDataSupplier);
        this.table.setHandler(this.handler);
    }

    public MultiTableWidget<CommissionsWidgetVM, CommissionsEntryVM> getTable() {
        return this.table;
    }

    public void readData(CommissionsWidgetVM model) {
        this.table.readData((Object)model);
    }

    public void writeData(CommissionsWidgetVM model) {
        this.table.writeData((Object)model);
    }

    public boolean isDataChanged() {
        return this.table.isDataChanged();
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(CommissionsWidget2.this.table);
            }

            public String getInfo() {
                return ((Object)((Object)CommissionsWidget2.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)CommissionsWidget2.this.getViewState());
            }
        };
    }

    public static interface ProductDataSupplier {
        public ProductType getProductType();

        public List<SegmentTariff> getSegmentTariffs();

        public boolean isUseSegmentColumn();
    }
}

