/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomLabel;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.IntValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.res.Styles;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.common.model.system.DateCorrection;
import com.gridnine.xtrip.common.model.system.DateCorrectionUnit;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class DateCorrectionWidget
extends CustomWidget<DateCorrection>
implements DevTool {
    private Integer originalValue;
    private DateCorrectionUnit originalUnit;
    private final ObjectProperty<Integer> value = new SimpleObjectProperty();
    private final ObjectProperty<DateCorrectionUnit> unit = new SimpleObjectProperty();
    private Label label;
    private IntValueWidget valueWidget;
    private ComboBoxWidget<DateCorrectionUnit> unitWidget;
    private final ViewState viewState = new ViewState();

    public DateCorrectionWidget(boolean readOnly) {
        this.viewState.setReadonly(readOnly);
        this.viewState.stateProperty().addListener((observable, oldValue, newValue) -> this.update());
        this.getStyleClass().addAll((Object[])new String[]{"date-correction-widget"});
        this.update();
    }

    public void setFieldName(String val) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(DateCorrection model) {
        this.setValue(model);
    }

    public void writeData(DateCorrection model) {
        DateCorrection value = this.getValue();
        model.setValue(value != null ? value.getValue() : 0);
        model.setUnit(value != null ? value.getUnit() : null);
    }

    public boolean isDataChanged() {
        return MiscUtil.equals((Object)this.originalValue, (Object)this.value.get()) && MiscUtil.equals((Object)this.originalUnit, (Object)this.unit.get());
    }

    public void setValue(DateCorrection value) {
        this.originalValue = value != null && value.getValue() != 0 ? Integer.valueOf(value.getValue()) : null;
        this.originalUnit = value != null ? value.getUnit() : null;
        this.value.set(value != null && value.getValue() != 0 ? Integer.valueOf(value.getValue()) : null);
        this.unit.set((Object)(value != null ? value.getUnit() : null));
        this.update();
    }

    public DateCorrection getValue() {
        if (this.value.get() != null && this.unit.get() != null) {
            DateCorrection value = new DateCorrection();
            value.setValue(((Integer)this.value.get()).intValue());
            value.setUnit((DateCorrectionUnit)this.unit.get());
            return value;
        }
        return null;
    }

    public ObjectProperty<Integer> valueProperty() {
        return this.value;
    }

    public ObjectProperty<DateCorrectionUnit> unitProperty() {
        return this.unit;
    }

    private void update() {
        if (this.viewState.isImmutable()) {
            this.valueWidget = null;
            this.unitWidget = null;
            if (this.label == null) {
                this.label = new CustomLabel();
                this.label.getStyleClass().add((Object)"value-label");
                this.getChildren().setAll((Object[])new Node[]{this.label});
            }
            this.label.setText(this.value.get() != null && this.unit.get() != null ? this.value.get() + " " + this.unit.get() : UiUtil.NULL_TEXT);
        } else {
            this.label = null;
            if (this.valueWidget == null && this.unitWidget == null) {
                this.valueWidget = new IntValueWidget(false);
                this.valueWidget.getStyleClass().add((Object)"value");
                this.valueWidget.valueProperty().addListener((observable, oldValue, newValue) -> this.value.set(newValue));
                HBox.setHgrow((Node)this.valueWidget, (Priority)Priority.ALWAYS);
                this.unitWidget = new ComboBoxWidget(false);
                this.unitWidget.getStyleClass().add((Object)"unit");
                this.unitWidget.setItemsSupplier(Suppliers.createEnumSupplier(DateCorrectionUnit.class));
                this.unitWidget.setConverter((StringConverter)new StringConverter<DateCorrectionUnit>(){

                    public String toString(DateCorrectionUnit object) {
                        return object != null ? object.toString() : UiUtil.NULL_TEXT;
                    }

                    public DateCorrectionUnit fromString(String string) {
                        return null;
                    }
                });
                this.unitWidget.setNoNulls(true);
                this.unitWidget.guessPrefWidth();
                this.unitWidget.valueProperty().addListener((observable, oldValue, newValue) -> this.unit.set(newValue));
                this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.valueWidget, this.unitWidget})});
            }
            this.valueWidget.setValue((Number)this.value.get());
            this.unitWidget.setValue(this.unit.get());
        }
        this.pseudoClassStateChanged(Styles.READONLY_PSEUDOCLASS, this.viewState.isImmutable());
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                if (DateCorrectionWidget.this.valueWidget != null && DateCorrectionWidget.this.unitWidget != null) {
                    return Arrays.asList(DateCorrectionWidget.this.valueWidget, DateCorrectionWidget.this.unitWidget);
                }
                return Collections.emptyList();
            }

            public String getInfo() {
                return ((Object)((Object)DateCorrectionWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)DateCorrectionWidget.this.viewState);
            }
        };
    }
}

