/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.lib.components.ControlsPane;
import com.gridnine.xtrip.client.fx.core.lib.components.CustomTextArea;
import com.gridnine.xtrip.client.fx.core.lib.components.PlaceholderPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.dict.SpellVariantVM;
import com.gridnine.xtrip.client.fx.model.dict.SpellVariantsPanelVM;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.TextArea;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class SpellVariantsWidget
extends CustomWidget<SpellVariantsPanelVM> {
    private final PlaceholderPane placeholderPane;
    protected final ViewState viewState = new ViewState();
    protected ListView<ValueHolder<String>> listView;
    private SpellVariantsPanelVM data;

    public SpellVariantsWidget(boolean ro) {
        this.viewState.setReadonly(ro);
        this.getStyleClass().add((Object)"spell-variants-widget");
        this.placeholderPane = new PlaceholderPane();
        this.placeholderPane.setPlaceholder(new Label(Messages.No_Data));
        ControlsPane controlsPane = new ControlsPane();
        controlsPane.addButton(ControlsPane.ButtonType.ADD, evt -> this.addItem());
        this.placeholderPane.setControlsPane(controlsPane);
        this.viewState.stateProperty().addListener((s, o, n) -> {
            controlsPane.setVisible(!ViewState.isImmutable((int)n.intValue()));
            this.updateState();
        });
        this.getChildren().add((Object)this.placeholderPane);
    }

    public void setFieldName(String value) {
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public void readData(SpellVariantsPanelVM model) {
        this.data = model;
        if (model.getContent().isEmpty()) {
            this.destroyListView();
        } else {
            this.initListView();
            this.listView.getItems().setAll((Collection)model.getContent().stream().map(vm -> new ValueHolder((Object)vm.getSpellVariant())).collect(Collectors.toList()));
        }
    }

    public void writeData(SpellVariantsPanelVM model) {
        model.getContent().clear();
        if (this.listView != null) {
            this.listView.getItems().stream().filter(vm -> !TextUtil.isBlank((String)((String)vm.get()))).map(item -> {
                SpellVariantVM vm = new SpellVariantVM();
                vm.setSpellVariant((String)item.get());
                return vm;
            }).collect(Collectors.toCollection(() -> ((SpellVariantsPanelVM)model).getContent()));
        }
        this.data = model;
    }

    public boolean isDataChanged() {
        if (this.listView == null) {
            if (this.data == null || this.data.getContent() == null) {
                return false;
            }
            return !this.data.getContent().isEmpty();
        }
        if (this.data == null || this.data.getContent() == null || this.data.getContent().isEmpty()) {
            return !this.listView.getItems().isEmpty();
        }
        return !CollectionUtil.equals((Collection)this.data.getContent(), (Collection)this.listView.getItems(), (obj1, obj2) -> {
            if (obj1 == null || obj2 == null) {
                return false;
            }
            return MiscUtil.equals((Object)obj1.getSpellVariant(), (Object)obj2.get());
        }, (boolean)false);
    }

    private void updateState() {
        if (this.listView != null) {
            this.listView.refresh();
        }
    }

    private void initListView() {
        if (this.listView != null) {
            return;
        }
        this.listView = new ListView();
        this.listView.setCellFactory(lv -> new SpellVariantCell());
        this.getChildren().setAll((Object[])new Node[]{this.listView});
    }

    protected void destroyListView() {
        if (this.listView == null) {
            return;
        }
        this.listView = null;
        this.getChildren().setAll((Object[])new Node[]{this.placeholderPane});
    }

    protected void addItem() {
        this.initListView();
        this.listView.getItems().add((Object)new ValueHolder());
        this.listView.scrollTo(this.listView.getItems().size() - 1);
    }

    class SpellVariantCell
    extends ListCell<ValueHolder<String>> {
        private HBox box;
        private TextArea textArea;
        private ControlsPane controlsPane;

        SpellVariantCell() {
        }

        protected void updateItem(ValueHolder<String> item, boolean empty) {
            super.updateItem(item, empty);
            if (empty) {
                this.setGraphic(null);
                return;
            }
            if (this.textArea == null) {
                this.textArea = new CustomTextArea();
                this.textArea.textProperty().addListener((s, o, n) -> {
                    ValueHolder itm = (ValueHolder)this.getItem();
                    if (itm != null) {
                        itm.set(n);
                    }
                });
                HBox.setHgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
                this.box = new HBox(new Node[]{this.textArea});
            }
            boolean editable = !SpellVariantsWidget.this.viewState.isImmutable();
            this.textArea.setEditable(editable);
            this.textArea.setText((String)item.get());
            if (!editable) {
                if (this.controlsPane != null) {
                    this.box.getChildren().remove((Object)this.controlsPane);
                    this.controlsPane = null;
                }
            } else if (this.controlsPane == null) {
                this.controlsPane = new ControlsPane();
                this.controlsPane.addButton(ControlsPane.ButtonType.REMOVE, evt -> {
                    ValueHolder itm = (ValueHolder)this.getItem();
                    if (itm != null) {
                        SpellVariantsWidget.this.listView.getItems().remove((Object)itm);
                        if (SpellVariantsWidget.this.listView.getItems().isEmpty()) {
                            SpellVariantsWidget.this.destroyListView();
                        }
                    }
                });
                this.controlsPane.addButton(ControlsPane.ButtonType.ADD, evt -> SpellVariantsWidget.this.addItem());
                this.box.getChildren().add((Object)this.controlsPane);
            }
            this.setGraphic((Node)this.box);
        }
    }
}

