/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.NestedEntityBoxWidget;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.system.ValidatorValuePair;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.property.ObjectProperty;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class ValidatorEntityBoxWidget
extends CustomWidget<ValidatorValuePair> {
    private final Label codeLabel;
    protected final NestedEntityBoxWidget<SalesPoint, Validator> widget;
    private String validatorCode;
    private boolean dataChanged = false;

    public ValidatorEntityBoxWidget(boolean readonly) {
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.codeLabel = new Label();
        this.getStyleClass().addAll((Object[])new String[]{"xtrip-validator-widget", "simple-widget"});
        this.widget = new NestedEntityBoxWidget(SalesPoint.class, Validator.class, readonly);
        this.widget.valueProperty().addListener((s, o, n) -> {
            this.validatorCode = n == null ? null : n.getCaption();
            this.dataChanged = true;
            this.updateViewState();
        });
        this.widget.setConverter((StringConverter)new StringConverter<NestedEntityReference<SalesPoint, Validator>>(){

            public String toString(NestedEntityReference<SalesPoint, Validator> ref) {
                if (ref != null && ref.getCaption() != null) {
                    return ref.getCaption();
                }
                return ValidatorEntityBoxWidget.this.widget.getViewState().isImmutable() ? "\u2014" : UiUtil.NULL_TEXT;
            }

            public NestedEntityReference<SalesPoint, Validator> fromString(String string) {
                return null;
            }
        });
        HBox.setHgrow(this.widget, (Priority)Priority.ALWAYS);
        this.getChildren().setAll((Object[])new Node[]{new HBox(new Node[]{this.widget, this.codeLabel})});
        this.widget.getViewState().stateProperty().addListener((s, o, n) -> this.updateViewState());
    }

    public void requestFocus() {
        this.widget.requestFocus();
    }

    public String getValidatorCode() {
        return this.validatorCode;
    }

    public void setValidatorCode(String value) {
        this.validatorCode = value;
        this.dataChanged = true;
        this.updateViewState();
    }

    public void setFieldName(String value) {
        this.widget.setFieldName(value);
    }

    public void readData(ValidatorValuePair model) {
        this.widget.setValue((EntityReference)(model != null ? model.getReference() : null));
        this.validatorCode = model != null ? model.getCode() : null;
        this.dataChanged = false;
        this.updateViewState();
    }

    public void writeData(ValidatorValuePair model) {
        model.setReference((NestedEntityReference)this.widget.getValue());
        model.setCode(this.validatorCode);
    }

    public ViewState getViewState() {
        return this.widget.getViewState();
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public void setListParametersSupplier(Supplier<IndexListParameters<SalesPoint, ?>> value) {
        this.widget.setListParametersSupplier(value);
    }

    public void setNestedReferenceBuilder(Function<EntityIndex<SalesPoint>, NestedEntityReference<SalesPoint, Validator>> value) {
        this.widget.setNestedReferenceBuilder(value);
    }

    public void setNavigationCallback(Consumer<RootEntityPane<?, ?>> value) {
        this.widget.setNavigationCallback(value);
    }

    public ObjectProperty<NestedEntityReference<SalesPoint, Validator>> valueProperty() {
        return this.widget.valueProperty();
    }

    private void updateViewState() {
        this.codeLabel.setText(this.validatorCode);
        this.widget.redraw();
        UiUtil.setHidden((Node)this.codeLabel, (TextUtil.isBlank((String)this.codeLabel.getText()) || MiscUtil.equals((Object)this.widget.getText(), (Object)this.codeLabel.getText()) ? 1 : 0) != 0);
    }
}

