/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.custom.metadata;

import com.gridnine.xtrip.client.fx.core.devtools.DevTools;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevTool;
import com.gridnine.xtrip.client.fx.core.devtools.api.DevToolItem;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.CustomWidget;
import com.gridnine.xtrip.client.fx.core.util.HasValue;
import com.gridnine.xtrip.client.fx.core.util.HasViewState;
import com.gridnine.xtrip.client.fx.core.util.ViewState;
import com.gridnine.xtrip.client.fx.model.custom.metadata.MetadataHolder;
import com.gridnine.xtrip.client.fx.standard.custom.metadata.MetadataHelper;
import com.gridnine.xtrip.client.fx.standard.custom.metadata.MetadataWidgetValueWrapper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;

public class MetadataWidget
extends CustomWidget<MetadataHolder>
implements DevTool {
    private boolean dataChanged;
    private final ViewState viewState = new ViewState();
    private final SimpleBooleanProperty hidden = new SimpleBooleanProperty(true);
    private final GridContainer body = new GridContainer(4);
    private final Map<DictionaryReference<MetadataKeyDescriptor>, GridCell<Pane>> descriptorsToCellsMap = new HashMap<DictionaryReference<MetadataKeyDescriptor>, GridCell<Pane>>();

    public MetadataWidget(boolean readonly) {
        this.getChildren().add((Object)this.body);
        this.viewState.setReadonly(readonly);
        this.viewState.stateProperty().addListener((s, o, n) -> this.body.getCells().forEach(cell -> ((HasViewState)cell.getPayload()).getViewState().setReadonly(ViewState.isReadonly((int)n.intValue()))));
    }

    public void setFieldName(String value) {
    }

    public void readData(MetadataHolder holder) {
        this.body.getCells().clear();
        this.descriptorsToCellsMap.clear();
        holder.getValueHolders().forEach(valueHolder -> {
            MetadataWidgetValueWrapper wrapper = MetadataHelper.getValueWrapper(valueHolder.getValueType());
            if (wrapper != null) {
                HasValue<?> valuePane = wrapper.createValueWidget(this.viewState.isReadonly());
                wrapper.getValueProperty(valuePane).addListener((s, o, n) -> {
                    this.dataChanged = true;
                });
                GridCell cell = new GridCell(valueHolder.getCaption(), (Node)((Pane)valuePane));
                wrapper.setValue((HasValue)cell.getPayload(), valueHolder.getValue());
                this.body.getCells().add((Object)cell);
                this.descriptorsToCellsMap.put((DictionaryReference<MetadataKeyDescriptor>)valueHolder.getKey(), (GridCell<Pane>)cell);
            }
        });
        this.hidden.set(this.descriptorsToCellsMap.isEmpty());
        this.dataChanged = false;
    }

    public void writeData(MetadataHolder holder) {
        ArrayList result = new ArrayList();
        holder.getValueHolders().forEach(valueHolder -> {
            GridCell<Pane> cell = this.descriptorsToCellsMap.get(valueHolder.getKey());
            if (cell != null) {
                MetadataWidgetValueWrapper wrapper = MetadataHelper.getValueWrapper(valueHolder.getValueType());
                valueHolder.setValue(wrapper.getValue((HasValue)cell.getPayload()));
                result.add(valueHolder);
            }
        });
        holder.getValueHolders().clear();
        holder.getValueHolders().addAll(result);
        this.dataChanged = false;
    }

    public boolean isDataChanged() {
        return this.dataChanged;
    }

    public ViewState getViewState() {
        return this.viewState;
    }

    public SimpleBooleanProperty getIsHiddenProperty() {
        return this.hidden;
    }

    public DevToolItem asDevToolItem() {
        return new DevToolItem(){

            public Collection<?> getSubItems() {
                return Collections.singleton(MetadataWidget.this.body);
            }

            public String getInfo() {
                return ((Object)((Object)MetadataWidget.this)).getClass().getSimpleName() + DevTools.getViewStateInfo((ViewState)MetadataWidget.this.viewState);
            }
        };
    }
}

