/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.demo;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.entity.EntityIndexHandler;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.QuickHelp;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.CellsContainerColumn;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.ComplexCell;
import com.gridnine.xtrip.client.fx.core.lib.container.cells.SimpleCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.Tile;
import com.gridnine.xtrip.client.fx.core.lib.container.tiles.TilesSpace;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextAreaWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItemType;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.ServerTaskHandler;
import com.gridnine.xtrip.client.fx.core.ui.tab.BaseContentPane;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.ObservableMutex;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.custom.SabreMaskWidget;
import com.gridnine.xtrip.client.fx.standard.demo.EditorsTesterTask;
import com.gridnine.xtrip.client.fx.standard.demo.MetaRegistryBrowserPane;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleActionRenderer;
import com.gridnine.xtrip.client.fx.standard.rules.renderers.RuleValueRenderer;
import com.gridnine.xtrip.common.meta.BaseMetaElement;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.BaseSystemSettings;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.RandomUtil;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableObjectValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.Region;

class DemoHomePane
extends BaseContentPane {
    DemoHomePane() {
        this.composePane((Node)new TilesSpace(1){
            {
                this.addTiles(new Tile[]{new Tile("main", "Demo Page", null, DemoHomePane.this.buildContentPane())});
            }
        }, null, null, null);
    }

    protected Node buildContentPane() {
        CardsContainer result = new CardsContainer();
        result.getCards().add((Object)new Card("general", UiCardsContainer.Style.EXPANDED, "General", this.buildGeneralPane()));
        result.getCards().add((Object)new Card("notifications", UiCardsContainer.Style.EXPANDED, "Notifications", this.buildNotificationsPane()));
        result.getCards().add((Object)new Card("dialogs", UiCardsContainer.Style.EXPANDED, "Dialogs", this.buildDialogsPane()));
        return result;
    }

    private Node buildGeneralPane() {
        ArrayList<Button> buttons = new ArrayList<Button>();
        Button button = new Button("Mask Editor");
        button.setOnAction(evt -> {
            TextFieldWidget maskWidget = new TextFieldWidget(false);
            maskWidget.setItemsSupplier(() -> Arrays.asList("######", "###-###-###", "U", "UUUU", "EMP-###", "S'UN-###", "******", "?'*?'*?"));
            SabreMaskWidget editorWidget = new SabreMaskWidget(false);
            editorWidget.setMaskSupplier(() -> ((TextFieldWidget)maskWidget).getValue());
            maskWidget.valueProperty().addListener((s, o, n) -> editorWidget.readData((ValueHolder<String>)new ValueHolder()));
            GridContainer ctr = new GridContainer(1);
            ctr.getCells().add((Object)new GridCell("Mask", (Node)maskWidget));
            GridCell cell = new GridCell("Value", (Node)editorWidget);
            cell.setHelp(() -> new QuickHelp("<html>\u041c\u0430\u0441\u043a\u0430 \u0432\u0432\u043e\u0434\u0430:\n<b>" + maskWidget.getValue() + "</b>"));
            ctr.getCells().add((Object)cell);
            new Dialog().setTitle("Mask Editor").setBody((Node)ctr).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)this);
        });
        buttons.add(button);
        button = new Button("Missing Editors Report");
        button.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(this.generateMissingEditorsReport());
            widget.getViewState().setNotEditable(true);
            widget.setMonospace(true);
            new Dialog().setTitle("Missing Editors Report").setMessage("Here is the list of non-deprecated dictionary types and root entities that have no registered editor.").setBody((Node)widget).setExpandToParent(true).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)this);
        });
        buttons.add(button);
        button = new Button("Missing Rule Handlers Report");
        button.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(this.generateMissingRuleHandlersReport());
            widget.getViewState().setNotEditable(true);
            widget.setMonospace(true);
            new Dialog().setTitle("Missing Rule Handlers Report").setMessage("Here is the list of rule property and action renderer IDs that have no registered handler.").setBody((Node)widget).setExpandToParent(true).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)this);
        });
        buttons.add(button);
        button = new Button("Meta Registry Browser");
        button.setOnAction(evt -> new Dialog().setTitle("Meta Registry Browser").setBody((Node)new MetaRegistryBrowserPane()).setExpandToParent(true).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)this));
        buttons.add(button);
        button = new Button("Client Registry Dump");
        button.setOnAction(evt -> {
            TextAreaWidget widget = new TextAreaWidget(true);
            widget.setValue(this.generateClientRegistryDump());
            widget.getViewState().setNotEditable(true);
            widget.setMonospace(true);
            new Dialog().setTitle("Client Registry Dump").setMessage("Here is the content of ClientRegistry object.").setBody((Node)widget).setExpandToParent(true).addButton(DialogButtonStyle.ACCEPT_REGULAR).show((Node)this);
        });
        buttons.add(button);
        button = new Button("Editors Tester");
        button.setOnAction(evt -> EditorsTesterTask.showSettingsDialog());
        buttons.add(button);
        FlowPane result = new FlowPane(20.0, 20.0);
        result.getChildren().addAll(buttons);
        return result;
    }

    private Node buildNotificationsPane() {
        ArrayList<Button> buttons = new ArrayList<Button>();
        Button button = new Button("Throw Error");
        button.setOnAction(evt -> ErrorHandler.handle((Throwable)Xeption.forEndUser((String)("fake error " + RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)100)), (Object[])new Object[0])));
        buttons.add(button);
        button = new Button("Flash Notification");
        button.setOnAction(evt -> Notifications.get().showFlashNotification("Flash notification. " + RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)100), RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)1000)));
        buttons.add(button);
        button = new Button("Static Notification");
        button.setOnAction(evt -> Notifications.get().showStaticNotification("Static notification. " + RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)100), RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)1000)));
        buttons.add(button);
        button = new Button("Static Notification with Action");
        button.setOnAction(evt -> Notifications.get().showStaticNotification("Action notification. " + RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)100), RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)1000), "Stop the World!", () -> Dialog.info((String)"Action executed!")));
        buttons.add(button);
        button = new Button("Messages Notification");
        button.setOnAction(evt -> {
            Message message1 = MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"test error message", (Throwable)Xeption.forDeveloper((String)"fake error", (Object[])new Object[0]), (Object[])new Object[0]);
            Message message2 = SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)1000), (Object[])new Object[0]);
            Message message3 = MessagesHelper.createMessageWithDetails((MessageType)MessageType.WARNING, (String)RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)10, (int)1000), (String)RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)100, (int)1000), (Object[])new Object[0]);
            Notifications.get().showMessages(new Message[]{message1, message2, message3});
        });
        buttons.add(button);
        button = new Button("Background Process");
        button.setOnAction(evt -> Notifications.get().submitTask(() -> Thread.sleep(5000L), "Some background process running. " + RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)5, (int)10)));
        buttons.add(button);
        button = new Button("Demo Async Server Task");
        button.setOnAction(evt -> Notifications.get().enqueueAsyncTask(new ServerTaskHandler(){
            private String titleSuffix = RandomUtil.getRandomString((RandomUtil.Chars)RandomUtil.Chars.ALPHA_NUM_SPEC, (int)5, (int)10);

            protected String getTitle() {
                return "Demo Async Server Task. " + this.titleSuffix;
            }

            protected void onCompleted(Object taskResult, List<Message> log) {
                log.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"got result in client: {0}", (Object[])new Object[]{taskResult}));
                this.titleSuffix = " COMPLETED!!!";
            }

            protected Serializable getTaskParameters() {
                return null;
            }

            protected String getTaskClassName() {
                return "com.gridnine.xtrip.server.fx.async.DemoAsyncTask";
            }
        }));
        buttons.add(button);
        button = new Button("Demo Async Client Task");
        button.setOnAction(evt -> Notifications.get().enqueueAsyncTask(new ClientTask(){
            private String titleSuffix = "0";

            protected String getTitle() {
                return "Demo Async Client Task. " + this.titleSuffix;
            }

            protected void execute() throws Exception {
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"async demo task started", (Object[])new Object[0])});
                for (int i = 0; i < 10; ++i) {
                    this.titleSuffix = String.valueOf(i);
                    this.setProgress((byte)(10 * i), "stage " + i);
                    Thread.sleep(1000L);
                }
                this.addMessages(new Message[]{SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"async demo task finished", (Object[])new Object[0])});
            }
        }));
        buttons.add(button);
        FlowPane result = new FlowPane(20.0, 20.0);
        result.getChildren().addAll(buttons);
        return result;
    }

    private Node buildDialogsPane() {
        ArrayList<Object> cells = new ArrayList<Object>();
        Button button = new Button("Info Dialog");
        button.setOnAction(evt -> Dialog.info((Node)this, (String)"Information message goes here.\nMessage may be multi-line.", (String)"This is the supplemental message. It's also wrappable as It's supposed to be while this text was being typed."));
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Dialog with message and button."));
        button = new Button("Confirm Dialog");
        button.setOnAction(evt -> Dialog.confirm((Node)this, (String)"Sure to format all storages in your PC?", (String)"Pavel Olenev is very busy nowadays, be careful.", (String)"Format", () -> {}, null));
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Dialog with: title, message and buttons."));
        button = new Button("Simple Dialog");
        button.setOnAction(evt -> new Dialog().setTitle("Dialog Title").setMessage("Dialog message comes here.").setBody((Node)new TextFieldWidget(false)).addButton(DialogButtonStyle.ACCEPT_CONTINUE).addButton(DialogButtonStyle.DECLINE).show((Node)this));
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Dialog with: title, message, body (simple widget) and buttons."));
        button = new Button("Complex Dialog");
        button.setOnAction(evt -> new Dialog().setTitle("Dialog Title").setExpandToParent(true).setMessage("Dialog message comes here.").setBody((Node)new DictsListPane(new ObservableMutex(), (MultiSupplier)new MultiSupplier<DictsListPaneConfiguration>(){
            private final DictHandler handler = DictHandler.forDictClass(GeoLocation.class);

            public String getDisplayName(int idx) {
                return "Geo Locations";
            }

            public DictsListPaneConfiguration get(int idx) {
                DictsListPaneConfiguration configuration = new DictsListPaneConfiguration(this.handler);
                configuration.setSelectionMode(SelectionMode.SINGLE);
                configuration.setPatternSearchEnabled(true);
                configuration.setActionsEnabled(false);
                configuration.applyParameters(this.handler.getStandardListParameters());
                return configuration;
            }

            public int count() {
                return 1;
            }
        })).addButton(DialogButtonStyle.AUXILARY, "Test").addButton(DialogButtonStyle.RESET).addButton(DialogButtonStyle.ACCEPT_CONTINUE).addButton(DialogButtonStyle.DECLINE).show((Node)this));
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Full screen dialog with: title, message, body (big container with widgets) and buttons."));
        button = new Button("Light Dialog");
        button.setOnAction(evt -> {
            ComboBoxWidget widget = new ComboBoxWidget(false);
            widget.setItemsSupplier(Suppliers.createEnumSupplier(PaymentType.class));
            widget.guessPrefWidth();
            new LightDialog().setTitle("Select Payment Type to Continue").setActionAvailability((BooleanExpression)Bindings.isNotNull((ObservableObjectValue)widget.valueProperty())).setBody((Node)widget).show((Region)button);
        });
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Lightweight dialog with title and body (simple combo-box widget)."));
        button = new Button("Nested Dialogs");
        button.setOnAction(evt -> {
            Dialog dialog = new Dialog();
            dialog.setTitle("Dialog Title").setMessage("Nested dialog example.").setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.AUXILARY, "Show nested", () -> Dialog.info((Node)button, (String)"This is nested dialog.")).addButton(DialogButtonStyle.ACCEPT_REGULAR, () -> ((Dialog)dialog).close()).show((Node)button);
        });
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Demonstrates showing dialog above another dialog."));
        button = new Button("Dialog with Notifications");
        button.setOnAction(evt -> {
            Dialog dialog = new Dialog();
            dialog.setTitle("Dialog Title").setMessage("Dialog with notifications example.").setAutoClose(false).setOnCloseRequest(() -> ((Dialog)dialog).close()).addButton(DialogButtonStyle.AUXILARY, "Message with details", () -> dialog.addValidationMessages(false, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)"notification message with detailes", (Throwable)Xeption.forDeveloper((String)"fake error", (Object[])new Object[0]), (Object[])new Object[0])})).addButton(DialogButtonStyle.AUXILARY, "Auto-hide Message", () -> dialog.addValidationMessages(true, new Message[]{MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"notification message that hides automatically", (Object[])new Object[0])})).show((Node)button);
        });
        cells.add(new ComplexCell((Node)button));
        cells.add(new SimpleCell("Demonstrates showing notification messages within dialog."));
        CellsContainer result = new CellsContainer();
        result.getColumns().addAll((Object[])new CellsContainerColumn[]{new CellsContainerColumn(30.0), new CellsContainerColumn()});
        result.getCells().addAll(cells);
        return result;
    }

    private String generateMissingEditorsReport() {
        Class cls;
        StringBuilder buf = new StringBuilder();
        ArrayList<Object> list = new ArrayList<Object>();
        for (DictionaryType dt2 : MetaRegistry.get().getDictionaries().values()) {
            try {
                if (dt2.isDeprecated() || DictHandler.forDictClass((Class)(cls = XSHelper.getClass((String)dt2.getId()))) != null) {
                    continue;
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            list.add(dt2);
        }
        if (list.isEmpty()) {
            buf.append("No missing dictionary editors found.");
        } else {
            buf.append("Missing dictionary editors (").append(list.size()).append("):");
            list.stream().sorted(Comparator.comparing(BaseMetaElement::getId)).forEach(dt -> buf.append("\n\t").append(dt.getId()).append('\t').append(dt.getDisplayName()));
        }
        buf.append("\n\n");
        list = new ArrayList();
        for (IndexType it2 : MetaRegistry.get().getIndexes().values()) {
            try {
                if (it2.isDeprecated() || it2.isHidden() || EntityIndexHandler.forIndexClass((Class)(cls = XSHelper.getClass((String)it2.getId()))) != null) {
                    continue;
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            list.add(it2);
        }
        if (list.isEmpty()) {
            buf.append("No missing entity index handlers found.");
        } else {
            buf.append("Missing entity index handlers (").append(list.size()).append("):");
            list.stream().sorted(Comparator.comparing(BaseMetaElement::getId)).forEach(it -> buf.append("\n\t").append(it.getId()).append('\t').append(it.getDisplayName()));
        }
        buf.append("\n\n");
        list = new ArrayList();
        for (EntityType ett2 : MetaRegistry.get().getEntities().values()) {
            try {
                if (ett2.isAbstract() || !MetaRegistryHelper.isRoot((EntityType)ett2) || ett2.isDeprecated() || ett2.isHidden() || BaseSystemSettings.class.isAssignableFrom(cls = XSHelper.getClass((String)ett2.getId())) && "true".equalsIgnoreCase((String)ett2.getParameters().get("useMetadataBasedSystemSettingsClientHandlerFX")) || RootEntityHandler.forEntityClass((Class)cls) != null) {
                    continue;
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            list.add(ett2);
        }
        if (list.isEmpty()) {
            buf.append("No missing root entity editors found.");
        } else {
            buf.append("Missing root entity editors (").append(list.size()).append("):");
            list.stream().sorted(Comparator.comparing(BaseMetaElement::getId)).forEach(ett -> buf.append("\n\t").append(ett.getId()).append('\t').append(ett.getDisplayName()));
        }
        return buf.toString();
    }

    private String generateMissingRuleHandlersReport() {
        RulesEnvironment re = RulesEnvironment.get();
        HashMap valueRenederers = new HashMap();
        HashMap actionRenederers = new HashMap();
        for (RuleTarget target : re.getTargets(null)) {
            ArrayList<String> list;
            for (RuleProperty prop : re.getProperties(target)) {
                if (valueRenederers.containsKey(prop.getRendererId())) {
                    ((List)valueRenederers.get(prop.getRendererId())).add(prop.getId() + '@' + target.getId());
                    continue;
                }
                if (RuleValueRenderer.forId(prop.getRendererId()) != null) continue;
                list = new ArrayList<String>();
                list.add(prop.getId() + '@' + target.getId());
                valueRenederers.put(prop.getRendererId(), list);
            }
            for (RuleAction action : re.getActions(target)) {
                if (actionRenederers.containsKey(action.getRendererId())) {
                    ((List)actionRenederers.get(action.getRendererId())).add(action.getId() + '@' + target.getId());
                    continue;
                }
                if (RuleActionRenderer.forId(action.getRendererId()) != null) continue;
                list = new ArrayList();
                list.add(action.getId() + '@' + target.getId());
                actionRenederers.put(action.getRendererId(), list);
            }
        }
        StringBuilder result = new StringBuilder();
        result.append("Missing property value renderers\n");
        if (valueRenederers.isEmpty()) {
            result.append("\tno missing renderers found\n");
        } else {
            result.append("Line format: <renderer-id> [<property-id>@<target-id>,...]\n");
            for (Map.Entry entry : valueRenederers.entrySet()) {
                result.append('\t').append((String)entry.getKey()).append('\t').append(((List)entry.getValue()).toString()).append('\n');
            }
        }
        result.append("\nMissing action renderers\n");
        if (actionRenederers.isEmpty()) {
            result.append("\tno missing renderers found\n");
        } else {
            result.append("Line format: <action-id> [<property-id>@<target-id>,...]\n");
            for (Map.Entry entry : actionRenederers.entrySet()) {
                result.append('\t').append((String)entry.getKey()).append('\t').append(((List)entry.getValue()).toString()).append('\n');
            }
        }
        return result.toString();
    }

    private String generateClientRegistryDump() {
        StringBuilder result = new StringBuilder();
        ClientRegistry registry = ClientRegistry.get();
        registry.getTypes().stream().sorted(Comparator.comparing(RegistryItemType::toString)).forEach(type -> {
            result.append(type).append('\n');
            for (RegistryItem item : registry.allOf(type).values()) {
                result.append('\t').append(item.getId()).append('\t').append(item.getClass().getName()).append('\n');
            }
        });
        return result.toString();
    }
}

