/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.demo;

import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.core.util.ModelCheckUtil;
import com.gridnine.xtrip.client.fx.core.util.ValueHolder;
import com.gridnine.xtrip.client.fx.standard.demo.EditorTester;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.Projection;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.RandomUtil;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

class RootEntityEditorTester
implements EditorTester {
    private final RootEntityHandler<?, ?> handler;

    static void collectAll(List<EditorTester> result) {
        ClientRegistry.get().allOf(RootEntityHandler.TYPE).values().stream().map(h -> new RootEntityEditorTester((RootEntityHandler<?, ?>)h)).collect(Collectors.toCollection(() -> result));
    }

    private RootEntityEditorTester(RootEntityHandler<?, ?> h) {
        this.handler = h;
    }

    public String toString() {
        return "ETT: " + RootEntityHandler.format(this.handler);
    }

    @Override
    public List<?> loadTestObjects(int limit) throws Exception {
        ServiceInvocationContext sic = ServiceInvocationContext.get();
        EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
        ProjectionQuery query = new ProjectionQuery();
        query.getProjections().add(Projection.count((String)"uid", (String)"count"));
        ProjectionResult pr = entityService.search(sic, this.handler.getStandardIndexClass(), query);
        int totalCount = ((Number)pr.get("count")).intValue();
        if (totalCount == 0) {
            return Collections.emptyList();
        }
        query = new SearchQuery();
        query.setLimit(limit);
        if (totalCount > limit) {
            query.setOffset(RandomUtil.RND.nextInt(totalCount - limit));
        }
        List searchResult = entityService.search(sic, this.handler.getStandardIndexClass(), (SearchQuery)query);
        Collections.shuffle(searchResult);
        return searchResult.stream().map(item -> item.getSource()).collect(Collectors.toList());
    }

    @Override
    public void doTest(Object obj) throws Exception {
        EntityReference ref = (EntityReference)obj;
        String token = RootEntityActivityHandler.buildToken(ref);
        FxUtil.waitForFxThread(() -> RootEntityEditingService.get().open(ref, true));
        boolean close = true;
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            ValueHolder editorPane = new ValueHolder();
            FxUtil.waitForFxThread(() -> ActivityManager.get().find(token, true, node -> editorPane.set((Object)((RootEntityPane)node))));
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            while (editorPane.get() == null || ((RootEntityPane)editorPane.get()).getMutex().isAcquired() || ((RootEntityPane)editorPane.get()).getData() == null) {
                Thread.sleep(333L);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            Thread.sleep(1000L);
            if (((RootEntityPane)editorPane.get()).getMode() != EditingMode.EDIT) {
                throw Xeption.forDeveloper((String)"\u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442 \u043d\u0435 \u0432 \u0440\u0435\u0436\u0438\u043c\u0435 \u0440\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
            }
            DataTransferPackage data1 = ((RootEntityPane)editorPane.get()).getData();
            ValueHolder dataChanged = new ValueHolder();
            FxUtil.waitForFxThread(() -> dataChanged.set((Object)((RootEntityPane)editorPane.get()).isDataChanged()));
            if (((Boolean)dataChanged.get()).booleanValue()) {
                throw Xeption.forDeveloper((String)"\u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0441\u0440\u0430\u0431\u043e\u0442\u0430\u043b \u0430\u043b\u0433\u043e\u0440\u0438\u0442\u043c \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 \u043d\u0430 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0435", (Object[])new Object[0]);
            }
            ((RootEntityPane)editorPane.get()).saveData();
            Thread.sleep(1000L);
            DataTransferPackage data2 = ((RootEntityPane)editorPane.get()).getData();
            ModelCheckUtil.compare((Identity)data1.getContainer().getEntity(), (Identity)data2.getContainer().getEntity());
        }
        catch (InterruptedException ie) {
            throw ie;
        }
        catch (Exception e) {
            close = false;
            throw e;
        }
        finally {
            if (close) {
                FxUtil.waitForFxThread(() -> ActivityManager.get().remove(token, true));
            }
        }
    }
}

