/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityManager;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListAction;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.standard.dicts.DictEditorActivityHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.DictEditorParameters;
import com.gridnine.xtrip.client.fx.standard.dicts.actions.DictActionsHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.meta.DictionaryType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import javafx.scene.control.Control;

public class EditDictListAction
implements DictsListAction {
    public ActionIcon getIcon(DictsListPane context) {
        return context.getDictHandler().isReadonly() || DictActionsHelper.areAllPredefined(context.getSelectedItems()) || ((DictionaryType)MetaRegistry.get().getDictionaries().get(context.getDictHandler().getDictType().getName())).isInternal() ? StandardActionIcons.VIEW : StandardActionIcons.EDIT;
    }

    public String getId() {
        return "dict-edit";
    }

    public double getWeight() {
        return 10.0;
    }

    public boolean isDefault() {
        return true;
    }

    public KeyBindingAction getKeyBindingAction() {
        return StandardKeyBindingActions.EDIT;
    }

    public String getName(DictsListPane context) {
        String suffix = DictActionsHelper.areAllPredefined(context.getSelectedItems()) ? "alt-name" : "name";
        String result = ClientRegistry.get().getResourceFor((RegistryItem)this, suffix);
        return result == null ? this.getId() : result;
    }

    public String getDescription(DictsListPane context) {
        return ClientRegistry.get().getResourceFor((RegistryItem)this, DictActionsHelper.areAllPredefined(context.getSelectedItems()) ? "alt-description" : "description");
    }

    public boolean isEnabled(DictsListPane context) {
        return context.getDictHandler() != null && !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, DictsListPane context, boolean alt) {
        boolean bgLoad = false;
        for (DictItem item : context.getSelectedItems()) {
            NavigationParameters parameters = new NavigationParameters();
            parameters.setTitle(item.getReference().getCaption());
            parameters.setParameters((Object)new DictEditorParameters(context.getDictHandler().getId(), item.getReference().getCode()));
            ActivityManager.get().navigate(DictEditorActivityHandler.buildToken(context.getDictHandler(), item.getReference().getCode()), (ActivityHandler)DictEditorActivityHandler.get(), parameters, false, null, bgLoad);
            bgLoad = true;
        }
    }
}

