/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListAction;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.Card;
import com.gridnine.xtrip.client.fx.core.lib.container.cards.CardsContainer;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.FileChooserWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.RadioBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ClientSettings;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.actions.DictActionsHelper;
import com.gridnine.xtrip.client.fx.standard.entity.actions.exporthelpers.ExportZipTask;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.DictItem;
import com.gridnine.xtrip.common.meta.ui.UiCardsContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.system.exchange.ExportType;
import com.gridnine.xtrip.common.model.system.exchange.ItemExportSettings;
import com.gridnine.xtrip.common.model.system.exchange.ItemType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.stage.FileChooser;
import org.apache.commons.io.FilenameUtils;

public class ExportDictListAction
implements DictsListAction {
    private static final Map<String, String> PATHS = new HashMap<String, String>();

    public ActionIcon getIcon(DictsListPane context) {
        return StandardActionIcons.EXPORT_LIST;
    }

    public double getWeight() {
        return 19.0;
    }

    public boolean isEnabled(DictsListPane context) {
        if (context.getDictHandler() == null || context.getSelectedItems().isEmpty()) {
            return false;
        }
        return !DictActionsHelper.areAllPredefined(context.getSelectedItems());
    }

    public void execute(Control source, DictsListPane context, boolean alt) {
        FileChooserWidget fileChooserWidget = new FileChooserWidget(false);
        fileChooserWidget.setMode(FileChooserWidget.ChoosingMode.SAVE);
        fileChooserWidget.setExtensionFiltersSupplier(() -> Collections.singletonList(new FileChooser.ExtensionFilter(Messages.Export_files_MOM, new String[]{"*.xml", "*.zip", "*.xls", "*.csv"})));
        fileChooserWidget.setDefaultFilePathBuilder(ExportDictListAction.getDefaultPathString(BookingFile.class));
        File file = ClientSettings.get().getLastExportFile();
        if (file != null) {
            fileChooserWidget.getFiles().add((Object)file);
            String path = ((File)fileChooserWidget.getFiles().get(0)).getPath();
            String extension = FilenameUtils.getExtension((String)path);
            if (TextUtil.nonBlank((String)extension)) {
                fileChooserWidget.setFileExtension('.' + extension);
            }
        }
        RadioBoxWidget<String> objectSelectionWidget = ExportDictListAction.getObjectSelectionWidget(context.getChildren().size(), true);
        CardsContainer cardsContainer = new CardsContainer();
        cardsContainer.getCards().add((Object)new Card("file", UiCardsContainer.Style.STATIC, Messages.File, (Node)GridContainer.wrap((Node)fileChooserWidget)));
        cardsContainer.getCards().add((Object)new Card("objectSelection", UiCardsContainer.Style.STATIC, Messages.Helper_Objects, (Node)GridContainer.wrap(objectSelectionWidget)));
        cardsContainer.setMinWidth(550.0);
        Dialog dialog = new Dialog();
        dialog.setTitle(Messages.Export_Parameters);
        dialog.setBody((Node)cardsContainer);
        dialog.addButton(DialogButtonStyle.DECLINE);
        dialog.addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.To_Export, () -> {
            try {
                if (fileChooserWidget.getFiles().isEmpty()) {
                    Dialog.info((String)Messages.No_file_selected);
                } else {
                    fileChooserWidget.setFileExtension(".zip");
                    ArrayList<ItemExportSettings> exportSettingsList = new ArrayList<ItemExportSettings>();
                    ItemExportSettings itemExportSettings = new ItemExportSettings();
                    itemExportSettings.setItemType(ItemType.DICTIONARY);
                    itemExportSettings.setObjectId(context.getDictHandler().getDictType().getName());
                    if (context.getSelectedItems().size() > 0 && ((String)objectSelectionWidget.getValue()).equals(Messages.Only_selected_objects)) {
                        itemExportSettings.setExportType(ExportType.SELECTED);
                        itemExportSettings.getSelectedItems().addAll(context.getSelectedItems().stream().map(DictItem::getReference).collect(Collectors.toList()));
                    } else if (((String)objectSelectionWidget.getValue()).equals(Messages.All_Objects)) {
                        itemExportSettings.setExportType(ExportType.ALL);
                    }
                    exportSettingsList.add(itemExportSettings);
                    Notifications.get().enqueueAsyncTask((ClientTask)new ExportZipTask((File)fileChooserWidget.getFiles().get(0), exportSettingsList));
                    dialog.close();
                }
            }
            catch (Exception ex) {
                ErrorHandler.handle((Throwable)ex);
            }
        }).setOnCloseRequest(() -> ((Dialog)dialog).close()).showGlobal();
    }

    public String getId() {
        return "dict-export-list";
    }

    public boolean isAvailable(DictsListPane context) {
        return true;
    }

    private static String getDefaultPathString(Class cls) {
        if (cls == null) {
            return "";
        }
        String objName = cls.getSimpleName().toLowerCase();
        return ExportDictListAction.getDefaultPathString(objName);
    }

    private static String getDefaultPathString(String entityName) {
        StringBuilder builder = new StringBuilder();
        builder.append(Environment.getDataFolder());
        if (ExportDictListAction.checkEntityForXML(entityName)) {
            builder.append(ExportDictListAction.getPaths().get(entityName));
        } else {
            builder.append(File.separator).append("export").append(File.separator).append(entityName).append("s").append(File.separator);
        }
        builder.append(entityName);
        builder.append('_');
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        builder.append(sdf.format(new Date()));
        return builder.toString();
    }

    private static boolean checkEntityForXML(String className) {
        return ExportDictListAction.getPaths().containsKey(className);
    }

    private static Map<String, String> getPaths() {
        return Collections.unmodifiableMap(PATHS);
    }

    private static RadioBoxWidget<String> getObjectSelectionWidget(int size, boolean forList) {
        RadioBoxWidget objectSelectionWidget = new RadioBoxWidget(false);
        objectSelectionWidget.setItemsSupplier(() -> {
            ArrayList<String> list = new ArrayList<String>();
            list.add(Messages.Only_selected_objects);
            list.add(Messages.All_Objects);
            return list;
        });
        if (size == 0 && forList) {
            objectSelectionWidget.valueProperty().set((Object)Messages.All_Objects);
            objectSelectionWidget.setDisabledItemChecker(value -> value.equals(Messages.Only_selected_objects));
        } else if (!forList) {
            objectSelectionWidget.valueProperty().set((Object)Messages.Only_selected_objects);
            objectSelectionWidget.setDisabledItemChecker(value -> value.equals(Messages.All_Objects));
        } else {
            objectSelectionWidget.valueProperty().set((Object)Messages.Only_selected_objects);
        }
        return objectSelectionWidget;
    }
}

