/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.AirlineAlliancePanel;
import com.gridnine.xtrip.client.fx.model.dict.AirlineAlliancePanelController;
import com.gridnine.xtrip.client.fx.model.dict.AirlineAlliancePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.AirlineAllianceControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.AirlineAlliance;
import com.gridnine.xtrip.common.model.dict.AirlineAllianceReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class AirlineAllianceHandler
extends BaseDictHandler<AirlineAlliancePanel, AirlineAlliance, AirlineAlliancePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.COL_NOT_UPDATE);
    }

    @Override
    protected void configureController(List<BiConsumer<AirlineAlliance, AirlineAlliancePanelVM>> toVM, List<BiConsumer<AirlineAlliancePanelVM, AirlineAlliance>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new AirlineAllianceControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setNotUpdate(model.isNotUpdatable());
            vm.getMain().setId(model.getCode());
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setNotUpdatable(vm.getMain().isNotUpdate());
            model.setCode(StringUtils.trim((String)vm.getMain().getId()));
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<AirlineAlliance> getDictType() {
        return AirlineAlliance.class;
    }

    public DictionaryReference<AirlineAlliance> createReference(String code) {
        return new AirlineAllianceReference(code);
    }

    @Override
    protected AirlineAlliancePanelVM createVM() {
        return new AirlineAlliancePanelVM();
    }

    @Override
    protected ViewController<AirlineAlliancePanel, AirlineAlliancePanelVM> createController() {
        return new AirlineAlliancePanelController(false);
    }
}

