/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.AirlineCityInfoPanel;
import com.gridnine.xtrip.client.fx.model.dict.AirlineCityInfoPanelController;
import com.gridnine.xtrip.client.fx.model.dict.AirlineCityInfoPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.AirlineCityInfoTableGeoLocationVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfo;
import com.gridnine.xtrip.common.model.dict.AirlineCityInfoReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class AirlineCityInfoHandler
extends BaseDictHandler<AirlineCityInfoPanel, AirlineCityInfo, AirlineCityInfoPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), AirlineCityInfo.Property.airline.name(), "\u0410\u0432\u0438\u0430\u043a\u043e\u043c\u043f\u0430\u043d\u0438\u044f", (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), AirlineCityInfo.Property.cities.name(), "\u041f\u0443\u043d\u043a\u0442\u044b \u043d\u0430\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u044f", (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<AirlineCityInfo, AirlineCityInfoPanelVM>> toVM, List<BiConsumer<AirlineCityInfoPanelVM, AirlineCityInfo>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setAirline(model.getAirline());
            vm.getMain().getLocation().clear();
            vm.getMain().getLocation().addAll(model.getCities().stream().map(el -> {
                AirlineCityInfoTableGeoLocationVM airlineVM = new AirlineCityInfoTableGeoLocationVM();
                airlineVM.setCountry(el);
                return airlineVM;
            }).collect(Collectors.toList()));
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
            DictHandlersHelper.spellVariantsToVM(model.getSpellVariants(), vm.getSpellVariants().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setAirline(vm.getMain().getAirline());
            model.getCities().clear();
            model.getCities().addAll(vm.getMain().getLocation().stream().map(AirlineCityInfoTableGeoLocationVM::getCountry).collect(Collectors.toSet()));
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
            DictHandlersHelper.spellVariantsFromVM(vm.getSpellVariants().getContent(), model.getSpellVariants());
        });
    }

    public Class<AirlineCityInfo> getDictType() {
        return AirlineCityInfo.class;
    }

    public DictionaryReference<AirlineCityInfo> createReference(String code) {
        return new AirlineCityInfoReference(code);
    }

    public String format(AirlineCityInfo dict) {
        if (dict.getAirline() != null) {
            return dict.getAirline().toString();
        }
        if (dict.getCode() != null) {
            return dict.getCode();
        }
        return "\u2014";
    }

    @Override
    protected AirlineCityInfoPanelVM createVM() {
        return new AirlineCityInfoPanelVM();
    }

    @Override
    protected ViewController<AirlineCityInfoPanel, AirlineCityInfoPanelVM> createController() {
        return new AirlineCityInfoPanelController(false);
    }
}

