/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.UiUtil;
import com.gridnine.xtrip.client.fx.model.dict.BlankTypeMainPanel;
import com.gridnine.xtrip.client.fx.model.dict.BlankTypeMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.BlankTypePanel;
import com.gridnine.xtrip.client.fx.model.dict.BlankTypePanelController;
import com.gridnine.xtrip.client.fx.model.dict.BlankTypePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BlankTypeReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.util.StringConverter;
import org.apache.commons.lang.StringUtils;

public class BlankTypeHandler
extends BaseDictHandler<BlankTypePanel, BlankType, BlankTypePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BlankType.Property.name.name(), Messages.Number, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BlankType.Property.couponsCount.name(), Messages.Number_of_coupons, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BlankType.Property.blankOwner.name(), Messages.Form_owner, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BlankType.Property.productCategory.name(), Messages.View, new Renderer(){

            public String getId() {
                return "BLANK_TYPE_PRODUCT_CATEGORY";
            }

            public String apply(Object o) {
                if (o == null) {
                    return "";
                }
                return BlankTypeHandler.this.getCategoryName((ProductCategory)o);
            }
        }));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BlankType.Property.blankCategory.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    protected void configureController(List<BiConsumer<BlankType, BlankTypePanelVM>> toVM, List<BiConsumer<BlankTypePanelVM, BlankType>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new BlankTypeControllerInterceptor());
        toVM.add((model, vm) -> {
            BlankTypeMainPanelVM main = vm.getMain();
            main.setId(model.getCode());
            main.setNumber(model.getName());
            main.setCouponNumber(model.getCouponsCount());
            main.setOwner(model.getBlankOwner());
            main.setSort(model.getProductCategory());
            main.setType(model.getBlankCategory());
        });
        fromVM.add((vm, model) -> {
            BlankTypeMainPanelVM main = vm.getMain();
            model.setCode(StringUtils.trim((String)main.getId()));
            model.setName(main.getNumber());
            model.setCouponsCount(main.getCouponNumber());
            model.setBlankOwner(main.getOwner());
            model.setProductCategory(main.getSort());
            model.setBlankCategory(main.getType());
        });
    }

    public Class<BlankType> getDictType() {
        return BlankType.class;
    }

    public DictionaryReference<BlankType> createReference(String code) {
        return new BlankTypeReference(code);
    }

    @Override
    protected BlankTypePanelVM createVM() {
        return new BlankTypePanelVM();
    }

    @Override
    protected ViewController<BlankTypePanel, BlankTypePanelVM> createController() {
        return new BlankTypePanelController(false);
    }

    public String format(BlankType dict) {
        return dict.getCode();
    }

    private String getCategoryName(ProductCategory category) {
        if (category == ProductCategory.AIR) {
            return Messages.Ticket;
        }
        return category.toString();
    }

    class BlankTypeControllerInterceptor
    extends ControllerInterceptor<BlankTypePanelVM, BlankTypePanelController> {
        BlankTypeControllerInterceptor() {
        }

        protected Class<BlankTypePanelController> getControllerClass() {
            return BlankTypePanelController.class;
        }

        protected void onCreate(BlankTypePanelController controller) {
            ComboBoxWidget categoryWidget = ((BlankTypeMainPanel)controller.getView().getMainCard().getContent()).getSortNode();
            categoryWidget.setConverter((StringConverter)new StringConverter<ProductCategory>(){

                public String toString(ProductCategory object) {
                    if (object == null) {
                        return UiUtil.NULL_TEXT;
                    }
                    return BlankTypeHandler.this.getCategoryName(object);
                }

                public ProductCategory fromString(String string) {
                    return null;
                }
            });
        }
    }
}

