/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.CommonReasonCodeMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.CommonReasonCodePanel;
import com.gridnine.xtrip.client.fx.model.dict.CommonReasonCodePanelController;
import com.gridnine.xtrip.client.fx.model.dict.CommonReasonCodePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.CommonReasonCode;
import com.gridnine.xtrip.common.model.dict.CommonReasonCodeReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.profile.ReasonCodeComparisonType;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class CommonReasonCodeHandler
extends BaseDictHandler<CommonReasonCodePanel, CommonReasonCode, CommonReasonCodePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CommonReasonCode.Property.type.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CommonReasonCode.Property.comparisonType.name(), Messages.Type_of_comparison, new Renderer(){

            public String getId() {
                return "REASON_CODE_COMPARISON_TYPE";
            }

            public String apply(Object o) {
                return o != null ? o.toString() : ReasonCodeComparisonType.AFS.toString();
            }
        }));
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CommonReasonCode.Property.sabreName.name(), Messages.Name_in_sabre, (Renderer)StandardRenderers.GENERIC));
        TableColumnSettings columnDescription = new TableColumnSettings();
        columnDescription.setId(CommonReasonCode.Property.description.name());
        columnDescription.setDisplayName(Messages.Description);
        columnDescription.setRenderer((Renderer)StandardRenderers.GENERIC);
        params.getColumns().add(columnDescription);
    }

    @Override
    protected void configureController(List<BiConsumer<CommonReasonCode, CommonReasonCodePanelVM>> toVM, List<BiConsumer<CommonReasonCodePanelVM, CommonReasonCode>> fromVM) {
        toVM.add((model, vm) -> {
            CommonReasonCodeMainPanelVM main = vm.getMain();
            main.setType(model.getType());
            main.setComparisonType(model.getComparisonType() != null ? model.getComparisonType() : ReasonCodeComparisonType.AFS);
            main.setCode(model.getCode());
            main.setDescription(model.getDescription());
            main.setNameInSabre(model.getSabreName());
        });
        fromVM.add((vm, model) -> {
            CommonReasonCodeMainPanelVM main = vm.getMain();
            model.setType(main.getType());
            model.setComparisonType(main.getComparisonType() != null ? main.getComparisonType() : null);
            model.setCode(StringUtils.trim((String)main.getCode()));
            model.setSabreName(main.getNameInSabre());
            model.setDescription(main.getDescription());
        });
    }

    public Class<CommonReasonCode> getDictType() {
        return CommonReasonCode.class;
    }

    public DictionaryReference<CommonReasonCode> createReference(String code) {
        return new CommonReasonCodeReference(code);
    }

    @Override
    protected CommonReasonCodePanelVM createVM() {
        return new CommonReasonCodePanelVM();
    }

    @Override
    protected ViewController<CommonReasonCodePanel, CommonReasonCodePanelVM> createController() {
        return new CommonReasonCodePanelController(false);
    }
}

