/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.DateUtils;
import com.gridnine.xtrip.client.fx.model.dict.CurrencyRateMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.CurrencyRatePanel;
import com.gridnine.xtrip.client.fx.model.dict.CurrencyRatePanelController;
import com.gridnine.xtrip.client.fx.model.dict.CurrencyRatePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.CurrencyRateControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQueryPseudoProperties;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateReference;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.search.SortOrder;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;

public class CurrencyRateHandler
extends BaseDictHandler<CurrencyRatePanel, CurrencyRate, CurrencyRatePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.currency.name(), Messages.Currency, (Renderer)StandardRenderers.CURRENCY_NAME));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.baseCurrency.name(), Messages.Base_currency, (Renderer)StandardRenderers.CURRENCY_NAME));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.date.name(), Messages.Start_date_of_action, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BaseDictionary.Property.created.name(), Messages.Date_of_entry, (Renderer)StandardRenderers.DATE));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.rate.name(), Messages.Rate2, (Renderer)StandardRenderers.NUMBER_NON_INTEGRAL));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.type.name(), Messages.Type_of_rate, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.tariffType.name(), Messages.Type_of_tariff, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.blankOwner.name(), Messages.Letterhead_owner, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.supplier.name(), Messages.Supplier, (Renderer)StandardRenderers.GENERIC));
        TableColumnSettings col = new TableColumnSettings();
        col.setId(DictQueryPseudoProperties.CURRENCY_RATE_CURRENCY);
        col.setType(CurrencyInfo.class.getName());
        col.setDisplayName(Messages.Currency);
        params.getFilters().add(col);
        col = new TableColumnSettings();
        col.setId(DictQueryPseudoProperties.CURRENCY_RATE_BASE_CURRENCY);
        col.setType(CurrencyInfo.class.getName());
        col.setDisplayName(Messages.Base_currency);
        params.getFilters().add(col);
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.type.name(), Messages.Type_of_rate, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.tariffType.name(), Messages.Type_of_tariff, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.blankOwner.name(), Messages.Letterhead_owner, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(this.getDictType(), CurrencyRate.Property.supplier.name(), Messages.Supplier, (Renderer)StandardRenderers.GENERIC));
        params.getSortings().put(CurrencyRate.Property.date.name(), SortOrder.DESC);
    }

    @Override
    protected void configureController(List<BiConsumer<CurrencyRate, CurrencyRatePanelVM>> toVM, List<BiConsumer<CurrencyRatePanelVM, CurrencyRate>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CurrencyRateControllerInterceptor());
        toVM.add((model, vm) -> {
            CurrencyRateMainPanelVM main = vm.getMain();
            main.setCurrency(model.getCurrency());
            main.setBaseCurrency(model.getBaseCurrency());
            main.setDate(DateUtils.asLocalDate((Date)model.getDate()));
            main.setRate(model.getRate());
            main.setType(model.getType());
            main.setBlankOwner(model.getBlankOwner());
            main.setSupplier(model.getSupplier());
            main.setTariffType(model.getTariffType());
        });
        fromVM.add((vm, model) -> {
            CurrencyRateMainPanelVM main = vm.getMain();
            model.setCurrency(main.getCurrency());
            model.setBaseCurrency(main.getBaseCurrency());
            model.setDate(DateUtils.asDate((LocalDate)main.getDate()));
            model.setRate(main.getRate());
            model.setType(main.getType());
            model.setBlankOwner(main.getBlankOwner());
            model.setSupplier(main.getSupplier());
            model.setTariffType(main.getTariffType());
        });
    }

    public String format(CurrencyRate dict) {
        return L10n.replace((String)Messages.Rate3, (Object[])new Object[]{dict.getBaseCurrency() == null ? "???" : dict.getBaseCurrency(), dict.getCurrency() == null ? "???" : dict.getCurrency()});
    }

    public Class<CurrencyRate> getDictType() {
        return CurrencyRate.class;
    }

    public DictionaryReference<CurrencyRate> createReference(String code) {
        return new CurrencyRateReference(code);
    }

    @Override
    protected CurrencyRatePanelVM createVM() {
        return new CurrencyRatePanelVM();
    }

    @Override
    protected ViewController<CurrencyRatePanel, CurrencyRatePanelVM> createController() {
        return new CurrencyRatePanelController(false);
    }
}

