/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.ExternalSystemsPanel;
import com.gridnine.xtrip.client.fx.model.dict.ExternalSystemsPanelController;
import com.gridnine.xtrip.client.fx.model.dict.ExternalSystemsPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.dict.ExternalSystemReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class ExternalSystemHandler
extends BaseDictHandler<ExternalSystemsPanel, ExternalSystem, ExternalSystemsPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<ExternalSystem, ExternalSystemsPanelVM>> toVM, List<BiConsumer<ExternalSystemsPanelVM, ExternalSystem>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setExternalSystem(model.getCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getExternalSystem()));
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<ExternalSystem> getDictType() {
        return ExternalSystem.class;
    }

    public DictionaryReference<ExternalSystem> createReference(String code) {
        return new ExternalSystemReference(code);
    }

    @Override
    protected ExternalSystemsPanelVM createVM() {
        return new ExternalSystemsPanelVM();
    }

    @Override
    protected ViewController<ExternalSystemsPanel, ExternalSystemsPanelVM> createController() {
        return new ExternalSystemsPanelController(false);
    }
}

