/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.GeoRegionPanel;
import com.gridnine.xtrip.client.fx.model.dict.GeoRegionPanelController;
import com.gridnine.xtrip.client.fx.model.dict.GeoRegionPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.GeoRegionControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoRegion;
import com.gridnine.xtrip.common.model.dict.GeoRegionReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class GeoRegionHandler
extends BaseDictHandler<GeoRegionPanel, GeoRegion, GeoRegionPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.COL_NOT_UPDATE);
    }

    @Override
    protected void configureController(List<BiConsumer<GeoRegion, GeoRegionPanelVM>> toVM, List<BiConsumer<GeoRegionPanelVM, GeoRegion>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new GeoRegionControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setNotUpdate(model.isNotUpdatable());
            vm.getMain().setCode(model.getCode());
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setNotUpdatable(vm.getMain().isNotUpdate());
            model.setCode(StringUtils.trim((String)vm.getMain().getCode()));
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<GeoRegion> getDictType() {
        return GeoRegion.class;
    }

    public DictionaryReference<GeoRegion> createReference(String code) {
        return new GeoRegionReference(code);
    }

    @Override
    protected GeoRegionPanelVM createVM() {
        return new GeoRegionPanelVM();
    }

    @Override
    protected ViewController<GeoRegionPanel, GeoRegionPanelVM> createController() {
        return new GeoRegionPanelController(false);
    }
}

