/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.dialog.LocaleValueWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.groups.ExpandedGroupsWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.core.util.Converters;
import com.gridnine.xtrip.client.fx.model.dict.InformationNoteOtherParametersContainer;
import com.gridnine.xtrip.client.fx.model.dict.InformationNotePanel;
import com.gridnine.xtrip.client.fx.model.dict.InformationNotePanelController;
import com.gridnine.xtrip.client.fx.model.dict.InformationNotePanelVM;
import com.gridnine.xtrip.client.fx.model.dict.InformationNotePriorityPanel;
import com.gridnine.xtrip.client.fx.model.dict.InformationNoteTextPanel;
import com.gridnine.xtrip.client.fx.model.dict.InformationNoteTextPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.NomenclatureControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.CompactConverter;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.InformationNoteReference;
import com.gridnine.xtrip.common.model.dict.InformationNoteType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;

public class InformationNoteHandler
extends BaseDictHandler<InformationNotePanel, InformationNote, InformationNotePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), InformationNote.Property.types.name(), Messages.Type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), InformationNote.Property.priority.name(), Messages.Priority, (Renderer)StandardRenderers.GENERIC));
        TableColumnSettings column = new TableColumnSettings();
        column.setId(InformationNote.Property.disabled.name());
        column.setDisplayName(Messages.show_dictionaries_title);
        column.setRenderer((Renderer)StandardRenderers.GENERIC);
        column.setType("boolean-actual-dict");
        params.getFilters().add(column);
    }

    @Override
    protected void configureController(List<BiConsumer<InformationNote, InformationNotePanelVM>> toVM, List<BiConsumer<InformationNotePanelVM, InformationNote>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new NomenclatureControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new ControllerInterceptor<InformationNotePanelVM, InformationNotePanelController>(){

            protected Class<InformationNotePanelController> getControllerClass() {
                return InformationNotePanelController.class;
            }

            protected void onCreate(InformationNotePanelController controller) {
                ((InformationNoteOtherParametersContainer)controller.getView().getOtherParametersCard().getContent()).getDisabledNode().setConverter(Converters.boolConverter((String)Messages.Dont_show_in_list, (String)Messages.Show_in_list));
                this.setConverters(controller);
                HashSet selectedLocales = new HashSet();
                ((ExpandedGroupsWidget)controller.getView().getInformationNoteTextCard().getContent()).getViews().addListener(change -> {
                    while (change.next()) {
                        change.getAddedSubList().forEach(textPanel -> {
                            LocaleValueWidget localeNode = textPanel.getLocaleNode();
                            localeNode.setNoNulls(true);
                            localeNode.setFilter(locale -> !selectedLocales.contains(locale));
                            localeNode.valueProperty().addListener((obj, o, n) -> {
                                selectedLocales.remove(o);
                                selectedLocales.add(n);
                            });
                        });
                        change.getRemoved().forEach(textPanel -> {
                            LocaleValueWidget localeNode = textPanel.getLocaleNode();
                            selectedLocales.remove(localeNode.getValue());
                        });
                    }
                });
                ((InformationNotePriorityPanel)controller.getView().getInformationNotePriorityCard().getContent()).getTypesNode().setItemsSupplier(() -> Arrays.asList(InformationNoteType.values()));
            }

            private void setConverters(InformationNotePanelController controller) {
                ((ExpandedGroupsWidget)controller.getView().getInformationNoteTextCard().getContent()).setConverter(new CompactConverter<InformationNoteTextPanel>(panel -> {
                    ArrayList<Object> list = new ArrayList<Object>();
                    if (panel.getLocaleNode().getValue() != null) {
                        list.add(StandardRenderers.LOCALE.apply((Object)panel.getLocaleNode().getValue()));
                    }
                    return list;
                }));
            }
        });
        toVM.add((model, vm) -> {
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
            vm.getInformationNotePriority().setPriority(model.getPriority());
            vm.getInformationNotePriority().getTypes().clear();
            vm.getInformationNotePriority().getTypes().addAll(model.getTypes());
            vm.getInformationNotePriority().setRequired(model.isPersistent());
            vm.getOtherParameters().setDisabled(model.isDisabled());
            List list = vm.getInformationNoteText();
            list.clear();
            model.getNotes().entrySet().forEach(entry -> {
                InformationNoteTextPanelVM translation = new InformationNoteTextPanelVM();
                translation.setLocale((Locale)entry.getKey());
                translation.setTranslation((String)entry.getValue());
                list.add(translation);
            });
        });
        fromVM.add((vm, model) -> {
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
            model.setPriority(vm.getInformationNotePriority().getPriority());
            model.getTypes().clear();
            model.getTypes().addAll(vm.getInformationNotePriority().getTypes());
            model.setPersistent(vm.getInformationNotePriority().isRequired());
            model.setDisabled(vm.getOtherParameters().isDisabled());
            Map workMap = model.getNotes();
            workMap.clear();
            vm.getInformationNoteText().forEach(translation -> workMap.put(translation.getLocale(), translation.getTranslation()));
        });
    }

    public Class<InformationNote> getDictType() {
        return InformationNote.class;
    }

    public DictionaryReference<InformationNote> createReference(String code) {
        return new InformationNoteReference(code);
    }

    @Override
    protected InformationNotePanelVM createVM() {
        return new InformationNotePanelVM();
    }

    @Override
    protected ViewController<InformationNotePanel, InformationNotePanelVM> createController() {
        return new InformationNotePanelController(false);
    }
}

