/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.LegalFormPanel;
import com.gridnine.xtrip.client.fx.model.dict.LegalFormPanelController;
import com.gridnine.xtrip.client.fx.model.dict.LegalFormPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.LegalFormControllerInterceptor;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.BaseLegalForm;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.LegalFormReference;
import java.util.List;
import java.util.function.BiConsumer;

public class LegalFormsHandler
extends BaseDictHandler<LegalFormPanel, LegalForm, LegalFormPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), BaseLegalForm.Property.abbreviations.name(), Messages.Abbreviation, (Renderer)StandardRenderers.TRANSLATIONS));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.COL_NOT_UPDATE);
    }

    @Override
    protected void configureController(List<BiConsumer<LegalForm, LegalFormPanelVM>> toVM, List<BiConsumer<LegalFormPanelVM, LegalForm>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new LegalFormControllerInterceptor());
        toVM.add((model, vm) -> {
            vm.getMain().setNotUpdate(model.isNotUpdatable());
            vm.getMain().setCountry(model.getCountry());
            vm.getMain().setIndividualEntrepreneur(model.isIndividualEntrepreneur());
            DictHandlersHelper.translationsToVM(model.getAbbreviations(), vm.getAbbreviation().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getFullName().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setNotUpdatable(vm.getMain().isNotUpdate());
            model.setCountry(vm.getMain().getCountry());
            model.setIndividualEntrepreneur(vm.getMain().isIndividualEntrepreneur());
            DictHandlersHelper.translationsFromVM(vm.getAbbreviation().getContent(), model.getAbbreviations());
            DictHandlersHelper.translationsFromVM(vm.getFullName().getContent(), model.getTranslations());
        });
    }

    public Class<LegalForm> getDictType() {
        return LegalForm.class;
    }

    public DictionaryReference<LegalForm> createReference(String code) {
        return new LegalFormReference(code);
    }

    @Override
    protected LegalFormPanelVM createVM() {
        return new LegalFormPanelVM();
    }

    @Override
    protected ViewController<LegalFormPanel, LegalFormPanelVM> createController() {
        return new LegalFormPanelController(false);
    }
}

