/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.MetadataKeyDescriptorMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.MetadataKeyDescriptorPanel;
import com.gridnine.xtrip.client.fx.model.dict.MetadataKeyDescriptorPanelController;
import com.gridnine.xtrip.client.fx.model.dict.MetadataKeyDescriptorPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptor;
import com.gridnine.xtrip.common.model.system.MetadataKeyDescriptorReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class MetadataKeyDescriptorHandler
extends BaseDictHandler<MetadataKeyDescriptorPanel, MetadataKeyDescriptor, MetadataKeyDescriptorPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), MetadataKeyDescriptor.Property.category.name(), Messages.Applicable_to, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), MetadataKeyDescriptor.Property.valueType.name(), Messages.Value_type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), MetadataKeyDescriptor.Property.predefined.name(), Messages.System, (Renderer)StandardRenderers.BOOLEAN));
    }

    @Override
    protected void configureController(List<BiConsumer<MetadataKeyDescriptor, MetadataKeyDescriptorPanelVM>> toVM, List<BiConsumer<MetadataKeyDescriptorPanelVM, MetadataKeyDescriptor>> fromVM) {
        toVM.add((model, vm) -> {
            MetadataKeyDescriptorMainPanelVM main = vm.getMain();
            main.setId(model.getCode());
            main.setApplicableTo(model.getCategory());
            main.setValueType(model.getValueType());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            MetadataKeyDescriptorMainPanelVM main = vm.getMain();
            model.setCode(StringUtils.trim((String)main.getId()));
            model.setCategory(main.getApplicableTo());
            model.setValueType(main.getValueType());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<MetadataKeyDescriptor> getDictType() {
        return MetadataKeyDescriptor.class;
    }

    public DictionaryReference<MetadataKeyDescriptor> createReference(String code) {
        return new MetadataKeyDescriptorReference(code);
    }

    @Override
    protected MetadataKeyDescriptorPanelVM createVM() {
        return new MetadataKeyDescriptorPanelVM();
    }

    @Override
    protected ViewController<MetadataKeyDescriptorPanel, MetadataKeyDescriptorPanelVM> createController() {
        return new MetadataKeyDescriptorPanelController(false);
    }
}

