/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.SpecialServiceRequestDictPanel;
import com.gridnine.xtrip.client.fx.model.dict.SpecialServiceRequestDictPanelController;
import com.gridnine.xtrip.client.fx.model.dict.SpecialServiceRequestDictPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestCategory;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDict;
import com.gridnine.xtrip.common.model.dict.SpecialServiceRequestDictReference;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.List;
import java.util.function.BiConsumer;

public class SpecialServiceRequestDictHandler
extends BaseDictHandler<SpecialServiceRequestDictPanel, SpecialServiceRequestDict, SpecialServiceRequestDictPanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(this.getDictType(), SpecialServiceRequestDict.Property.category.name(), Messages.Category, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<SpecialServiceRequestDict, SpecialServiceRequestDictPanelVM>> toVM, List<BiConsumer<SpecialServiceRequestDictPanelVM, SpecialServiceRequestDict>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setCategory(model.getCategory());
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCategory(vm.getCategory());
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
        ControllersRegistry.register((ControllerInterceptor)new SpecialServiceRequestControllerInterceptor());
    }

    public Class<SpecialServiceRequestDict> getDictType() {
        return SpecialServiceRequestDict.class;
    }

    public DictionaryReference<SpecialServiceRequestDict> createReference(String code) {
        return new SpecialServiceRequestDictReference(code);
    }

    @Override
    protected SpecialServiceRequestDictPanelVM createVM() {
        return new SpecialServiceRequestDictPanelVM();
    }

    @Override
    protected ViewController<SpecialServiceRequestDictPanel, SpecialServiceRequestDictPanelVM> createController() {
        return new SpecialServiceRequestDictPanelController(false);
    }

    static class SpecialServiceRequestControllerInterceptor
    extends ControllerInterceptor<SpecialServiceRequestDictPanelVM, SpecialServiceRequestDictPanelController> {
        SpecialServiceRequestControllerInterceptor() {
        }

        protected Class<SpecialServiceRequestDictPanelController> getControllerClass() {
            return SpecialServiceRequestDictPanelController.class;
        }

        protected void validateData(SpecialServiceRequestDictPanelController controller, List<Message> messages) {
            SpecialServiceRequestCategory ssrc = (SpecialServiceRequestCategory)((ComboBoxWidget)controller.getView().getCategoryCard().getContent()).getValue();
            if (ssrc == null) {
                messages.add(SystemHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.NoSpecialServiceRequestDictCategory, (Object[])new Object[0]));
            }
        }
    }
}

