/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.TrainNamePanel;
import com.gridnine.xtrip.client.fx.model.dict.TrainNamePanelController;
import com.gridnine.xtrip.client.fx.model.dict.TrainNamePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TrainName;
import com.gridnine.xtrip.common.model.dict.TrainNameReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class TrainNameHandler
extends BaseDictHandler<TrainNamePanel, TrainName, TrainNamePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<TrainName, TrainNamePanelVM>> toVM, List<BiConsumer<TrainNamePanelVM, TrainName>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setTrainName(model.getCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getTrainName()));
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<TrainName> getDictType() {
        return TrainName.class;
    }

    public DictionaryReference<TrainName> createReference(String code) {
        return new TrainNameReference(code);
    }

    @Override
    protected TrainNamePanelVM createVM() {
        return new TrainNamePanelVM();
    }

    @Override
    protected ViewController<TrainNamePanel, TrainNamePanelVM> createController() {
        return new TrainNamePanelController(false);
    }
}

