/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.ViewController;
import com.gridnine.xtrip.client.fx.model.dict.TrainTypePanel;
import com.gridnine.xtrip.client.fx.model.dict.TrainTypePanelController;
import com.gridnine.xtrip.client.fx.model.dict.TrainTypePanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.BaseDictHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.TrainType;
import com.gridnine.xtrip.common.model.dict.TrainTypeReference;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

public class TrainTypeHandler
extends BaseDictHandler<TrainTypePanel, TrainType, TrainTypePanelVM> {
    @Override
    protected void configureStandardListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
    }

    @Override
    protected void configureController(List<BiConsumer<TrainType, TrainTypePanelVM>> toVM, List<BiConsumer<TrainTypePanelVM, TrainType>> fromVM) {
        toVM.add((model, vm) -> {
            vm.setTrainType(model.getCode());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(StringUtils.trim((String)vm.getTrainType()));
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    public Class<TrainType> getDictType() {
        return TrainType.class;
    }

    public DictionaryReference<TrainType> createReference(String code) {
        return new TrainTypeReference(code);
    }

    @Override
    protected TrainTypePanelVM createVM() {
        return new TrainTypePanelVM();
    }

    @Override
    protected ViewController<TrainTypePanel, TrainTypePanelVM> createController() {
        return new TrainTypePanelController(false);
    }
}

