/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.aircraft;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.AircraftMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.AircraftPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.aircraft.AircraftHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.dict.Aircraft;
import java.util.List;
import java.util.function.BiConsumer;
import org.apache.commons.lang.StringUtils;

class StandardAircraftHandlerConfigurator
implements AircraftHandlerConfigurator {
    StandardAircraftHandlerConfigurator() {
    }

    @Override
    public void configureListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(Aircraft.class, Aircraft.Property.engine.name(), Messages.Engines_Type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(Aircraft.class, Aircraft.Property.seats.name(), Messages.Min_number_of_places, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(Aircraft.class, Aircraft.Property.maxSeats.name(), Messages.Max_number_of_places, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    public void configureController(List<BiConsumer<Aircraft, AircraftPanelVM>> toVM, List<BiConsumer<AircraftPanelVM, Aircraft>> fromVM) {
        toVM.add((model, vm) -> {
            AircraftMainPanelVM main = vm.getMain();
            main.setId(model.getCode());
            main.setEngineType(model.getEngine());
            main.setMinSeatNumber(model.getSeats());
            main.setMaxSeatNumber(model.getMaxSeats());
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            AircraftMainPanelVM main = vm.getMain();
            model.setCode(StringUtils.trim((String)main.getId()));
            model.setEngine(main.getEngineType());
            model.setSeats(main.getMinSeatNumber());
            model.setMaxSeats(main.getMaxSeatNumber());
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }
}

