/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.costcodecategory;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.CostCodeCategoryMainPanelVM;
import com.gridnine.xtrip.client.fx.model.dict.CostCodeCategoryPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.costcodecategory.CostCodeCategoryHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.model.SabreProfilesSettings;
import com.gridnine.xtrip.common.model.dict.CostCodeCategory;
import java.util.List;
import java.util.function.BiConsumer;

class StandardCostCodeCategoryHandlerConfigurator
implements CostCodeCategoryHandlerConfigurator {
    StandardCostCodeCategoryHandlerConfigurator() {
    }

    @Override
    public void configureListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.name.name(), Messages.Full_name_in_Saber, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.shortName.name(), Messages.Short_name_in_Saber, (Renderer)StandardRenderers.GENERIC));
        if (StandardCostCodeCategoryHandlerConfigurator.isSabreProfilesLoadEnabled()) {
            params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.externalSystemName.name(), Messages.Name_in_external_system, (Renderer)StandardRenderers.GENERIC));
        }
        params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.externalCategoryType.name(), Messages.Type_in_GetThere, (Renderer)StandardRenderers.GENERIC));
        if (StandardCostCodeCategoryHandlerConfigurator.isSabreProfilesLoadEnabled()) {
            params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.kdsType.name(), Messages.Kds_Type, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.concurType.name(), Messages.Concur_Type, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.connectProfileType.name(), Messages.ConnectProfile_Type, (Renderer)StandardRenderers.GENERIC));
            params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.raketaType.name(), Messages.Raketa_Type, (Renderer)StandardRenderers.GENERIC));
        }
        params.getColumns().add(DictHandlersHelper.createColumn(CostCodeCategory.class, CostCodeCategory.Property.costCenter.name(), Messages.Coast_Center, (Renderer)StandardRenderers.GENERIC));
    }

    @Override
    public void configureController(List<BiConsumer<CostCodeCategory, CostCodeCategoryPanelVM>> toVM, List<BiConsumer<CostCodeCategoryPanelVM, CostCodeCategory>> fromVM) {
        toVM.add((model, vm) -> {
            CostCodeCategoryMainPanelVM main = vm.getMain();
            main.setFullNameInSabre(model.getName());
            main.setShortNameInSabre(model.getShortName());
            main.setExternalSystemName(model.getExternalSystemName());
            main.setGetThereType(model.getExternalCategoryType());
            main.setKdsType(model.getKdsType());
            main.setConcurType(model.getConcurType());
            main.setConnectProfileType(model.getConnectProfileType());
            main.setRaketaType(model.getRaketaType());
            main.setCostCenter(model.isCostCenter());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
        });
        fromVM.add((vm, model) -> {
            CostCodeCategoryMainPanelVM main = vm.getMain();
            model.setName(main.getFullNameInSabre());
            model.setShortName(main.getShortNameInSabre());
            model.setExternalSystemName(main.getExternalSystemName());
            model.setExternalCategoryType(main.getGetThereType());
            model.setKdsType(main.getKdsType());
            model.setConcurType(main.getConcurType());
            model.setConnectProfileType(main.getConnectProfileType());
            model.setRaketaType(main.getRaketaType());
            model.setCostCenter(main.isCostCenter());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
        });
    }

    static boolean isSabreProfilesLoadEnabled() {
        SabreProfilesSettings sabreProfilesSettings = Prefetched.getData().getSabreProfilesSettings();
        return sabreProfilesSettings.isSyncActive() && sabreProfilesSettings.isLoadActive();
    }
}

