/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.handlers.geolocation;

import com.gridnine.xtrip.client.fx.core.dicts.DictListParameters;
import com.gridnine.xtrip.client.fx.core.lib.components.table.TableColumnSettings;
import com.gridnine.xtrip.client.fx.core.registry.basic.Renderer;
import com.gridnine.xtrip.client.fx.core.registry.basic.StandardRenderers;
import com.gridnine.xtrip.client.fx.model.dict.GeoLocationPanelVM;
import com.gridnine.xtrip.client.fx.standard.dicts.handlers.geolocation.GeoLocationHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.DictHandlersHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.DictQueryPseudoProperties;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.List;
import java.util.TimeZone;
import java.util.function.BiConsumer;

class StandardGeoLocationHandlerConfigurator
implements GeoLocationHandlerConfigurator {
    StandardGeoLocationHandlerConfigurator() {
    }

    @Override
    public void configureListParameters(DictListParameters params) {
        params.getColumns().add(DictHandlersHelper.COL_CODE);
        params.getColumns().add(DictHandlersHelper.COL_CODE_VARIANTS);
        params.getColumns().add(DictHandlersHelper.COL_TRANSLATIONS);
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.type.name(), Messages.Point_type, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.parent.name(), Messages.Affiliation, (Renderer)StandardRenderers.GENERIC));
        params.getColumns().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.timeZoneId.name(), Messages.Timezone, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, BaseDictionary.Property.code.name(), Messages.ID, (Renderer)StandardRenderers.GENERIC));
        TableColumnSettings col = new TableColumnSettings();
        col.setId(DictQueryPseudoProperties.CODE_SYSTEM);
        col.setType(CodeSystem.class.getName());
        col.setDisplayName(Messages.Code_system);
        params.getFilters().add(col);
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, BaseDictionary.Property.codeVariants.name(), Messages.Code, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.type.name(), Messages.Point_type, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.country.name(), Messages.Country, (Renderer)StandardRenderers.GENERIC));
        params.getFilters().add(DictHandlersHelper.createColumn(GeoLocation.class, GeoLocation.Property.parent.name(), Messages.Affiliation, (Renderer)StandardRenderers.GENERIC));
        params.getSortings().put(BaseDictionary.Property.translations.name(), SortOrder.ASC);
    }

    @Override
    public void configureController(List<BiConsumer<GeoLocation, GeoLocationPanelVM>> toVM, List<BiConsumer<GeoLocationPanelVM, GeoLocation>> fromVM) {
        toVM.add((model, vm) -> {
            vm.getMain().setCode(model.getCode());
            vm.getMain().setCountry(model.getCountry());
            vm.getMain().setParent(model.getParent());
            vm.getMain().setTimeZone(MiscUtil.convertToTimeZone((String)model.getTimeZoneId()));
            VMHelper.transfer(model.getRegions(), vm.getMain().getGeoRegions());
            vm.getMain().setType(model.getType());
            DictHandlersHelper.codeVariantsToVM(model.getCodeVariants(), vm.getCodeVariants().getContent());
            DictHandlersHelper.translationsToVM(model.getTranslations(), vm.getTranslations().getContent());
            DictHandlersHelper.spellVariantsToVM(model.getSpellVariants(), vm.getSpellVariants().getContent());
        });
        fromVM.add((vm, model) -> {
            model.setCode(vm.getMain().getCode().trim());
            model.setCountry(vm.getMain().getCountry());
            model.setParent(vm.getMain().getParent());
            VMHelper.transfer(vm.getMain().getGeoRegions(), model.getRegions());
            model.setTimeZoneId(MiscUtil.getTimeZoneId((TimeZone)vm.getMain().getTimeZone()));
            model.setType(vm.getMain().getType());
            DictHandlersHelper.codeVariantsFromVM(vm.getCodeVariants().getContent(), model.getCodeVariants());
            DictHandlersHelper.translationsFromVM(vm.getTranslations().getContent(), model.getTranslations());
            DictHandlersHelper.spellVariantsFromVM(vm.getSpellVariants().getContent(), model.getSpellVariants());
        });
    }
}

