/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.dicts.navtool;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.activity.ActivityHandler;
import com.gridnine.xtrip.client.fx.core.activity.ActivityState;
import com.gridnine.xtrip.client.fx.core.activity.NavToolable;
import com.gridnine.xtrip.client.fx.core.activity.NavigationParameters;
import com.gridnine.xtrip.client.fx.core.dicts.DictHandler;
import com.gridnine.xtrip.client.fx.core.dicts.DictionaryModificationEvent;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPane;
import com.gridnine.xtrip.client.fx.core.dicts.list.DictsListPaneConfiguration;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.registry.ClientRegistry;
import com.gridnine.xtrip.client.fx.core.registry.RegistryItem;
import com.gridnine.xtrip.client.fx.core.ui.navigation.NavTool;
import com.gridnine.xtrip.client.fx.core.util.MultiSupplier;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.client.fx.standard.dicts.navtool.DictsNavTool;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javafx.scene.control.SelectionMode;

public class DictsListActivityHandler
extends ActivityHandler<DictsListPane, Void>
implements NavToolable<DictsListPane, Void> {
    private static String ID = "dicts-activity-handler";

    public static DictsListActivityHandler get() {
        return (DictsListActivityHandler)DictsListActivityHandler.forId((String)ID);
    }

    public static void register(ClientRegistry registry) {
        if (!registry.allOf(TYPE).containsKey(ID)) {
            registry.register((RegistryItem)new DictsListActivityHandler());
        }
    }

    private DictsListActivityHandler() {
    }

    public String getId() {
        return ID;
    }

    protected DictsListPane createView(ActivityState<DictsListPane, Void> state) throws Exception {
        final ArrayList handlers = new ArrayList(ClientRegistry.get().allOf(DictHandler.TYPE).values());
        HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
        for (DictHandler handler : handlers) {
            if (!handler.isAvaibleInConfiguration()) continue;
            map.put(handler.getId(), AclQuery.AclQueryBuilder.get().entry(StandardRestrictionResourceOperations.VIEW.getId(), handler.getDictType().getName()).build());
        }
        Set grantedIds = FxAclUtil.applyACL(map);
        handlers.removeIf(dictHandler -> !grantedIds.contains(dictHandler.getId()));
        if (handlers.isEmpty()) {
            throw Xeption.forEndUser((String)Messages.No_dicts_to_display_avalable, (Object[])new Object[0]);
        }
        handlers.sort(Comparator.comparing(DictHandler::format));
        DictsListPane result = new DictsListPane(state.getMutex(), (MultiSupplier)new MultiSupplier<DictsListPaneConfiguration>(){

            public int count() {
                return handlers.size();
            }

            public String getDisplayName(int idx) {
                return DictHandler.format((DictHandler)((DictHandler)handlers.get(idx)));
            }

            public DictsListPaneConfiguration get(int idx) {
                DictsListPaneConfiguration config = new DictsListPaneConfiguration((DictHandler)handlers.get(idx));
                config.setSelectionMode(SelectionMode.MULTIPLE);
                config.setPatternSearchEnabled(true);
                config.setActionsEnabled(true);
                config.applyParameters(config.getHandler().getStandardListParameters());
                return config;
            }
        });
        EventBus.get().subscribe(DictionaryModificationEvent.TYPE, result.getModificationEventHandler());
        return result;
    }

    protected void onClosed(ActivityState<DictsListPane, Void> state) {
        DictsListPane pane = (DictsListPane)this.getView(state);
        if (pane == null) {
            return;
        }
        EventBus.get().unsubscribe((Object)pane.getModificationEventHandler());
    }

    protected void saveChanges(ActivityState<DictsListPane, Void> state) {
    }

    protected Serializer<Void> getSerializer() {
        return Serializer.VOID;
    }

    public void update(ActivityState<DictsListPane, Void> state, NavigationParameters<Void> parameters) {
        state.titleProperty().set((Object)parameters.getTitle());
        state.descriptionProperty().set((Object)parameters.getDescription());
        state.setParameters(null);
    }

    public boolean isSupported(NavTool<?> tool) {
        return tool instanceof DictsNavTool;
    }
}

