/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity;

import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.util.Serializer;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Objects;

public class RootEntityParameters {
    static final Serializer<RootEntityParameters> SERIALIZER = new Serializer<RootEntityParameters>(){

        public byte[] serialize(RootEntityParameters obj) throws Exception {
            return (obj.getHandlerId() + '|' + obj.getContainerUid() + '|' + obj.getEditingMode().name() + '|' + String.valueOf(obj.getVersion())).getBytes("utf-8");
        }

        public RootEntityParameters deserialize(byte[] data) throws Exception {
            String[] arr = new String(data, "utf-8").split("\\|");
            EditingMode mode = (EditingMode)CollectionUtil.findEnumConstant(EditingMode.class, (String)arr[2]);
            if (mode == null) {
                mode = EditingMode.VIEW;
            }
            RootEntityParameters result = new RootEntityParameters(arr[0], arr[1], mode);
            if (arr.length > 3) {
                result.setVersion(Integer.parseInt(arr[3]));
            }
            return result;
        }
    };
    private final String handlerId;
    private final String containerUid;
    private EditingMode editingMode;
    private int version;

    public RootEntityParameters(String handler, String uid, EditingMode mode) {
        this.handlerId = Objects.requireNonNull(handler);
        this.containerUid = Objects.requireNonNull(uid);
        this.editingMode = Objects.requireNonNull(mode);
    }

    String getHandlerId() {
        return this.handlerId;
    }

    String getContainerUid() {
        return this.containerUid;
    }

    EditingMode getEditingMode() {
        return this.editingMode;
    }

    void setEditingMode(EditingMode value) {
        this.editingMode = value;
    }

    int getVersion() {
        return this.version;
    }

    void setVersion(int value) {
        this.version = value;
    }
}

