/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.acl.FxAclUtil;
import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SimpleSuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.components.suggestions.SuggestionsHandler;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.tasks.StandardNotifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.util.StringConverter;

public abstract class BaseAbstractEntityCreateAction
implements IndexListAction {
    protected abstract Class<?> getBaseEntityClass();

    protected abstract String getDialogTitle();

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.ADD;
    }

    public double getWeight() {
        return -1.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return this.getBaseEntityClass().getName().equals(ett.getId());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        Notifications.get().submitTask(() -> {
            EntityType baseEtt = MetaRegistryHelper.getEntityType((String)this.getBaseEntityClass().getName());
            List types = MetaRegistry.get().getEntities().values().stream().filter(ett -> !ett.isAbstract() && MetaRegistryHelper.isAssignableFrom((EntityType)baseEtt, (EntityType)ett)).collect(Collectors.toCollection(ArrayList::new));
            HashMap<String, AclQuery> map = new HashMap<String, AclQuery>();
            for (EntityType type : types) {
                map.put(type.getId(), new AclQuery(StandardRestrictionResourceOperations.EDIT.getId(), type.getId()));
            }
            Set grantedIds = FxAclUtil.applyACL(map);
            Iterator it = types.iterator();
            while (it.hasNext()) {
                EntityType type = (EntityType)it.next();
                if (grantedIds.contains(type.getId()) && AppConfigHelper.isInScope(type)) continue;
                it.remove();
            }
            types.sort((ett1, ett2) -> ett1.getDisplayName().compareTo(ett2.getDisplayName()));
            FxUtil.submitToFxThread(() -> this.showDialog(source, types));
        }, context.getMutex());
    }

    private void showDialog(Control source, List<EntityType> types) {
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> types);
        widget.setConverter((StringConverter)new StringConverter<EntityType>(){

            public String toString(EntityType object) {
                if (object == null) {
                    return null;
                }
                return object.getDisplayName();
            }

            public EntityType fromString(String string) {
                return null;
            }
        });
        widget.setSortItems(false);
        widget.setNoNulls(true);
        if (!types.isEmpty()) {
            widget.setValue((Object)types.get(0));
        }
        widget.guessPrefWidth();
        widget.setSuggestionsHandler((SuggestionsHandler)new SimpleSuggestionsHandler(widget.getConverter(), widget.getItemsSupplier(), widget.isSortItems()));
        new LightDialog().setTitle(this.getDialogTitle()).setBody((Node)widget).setActionHandler(() -> {
            try {
                RootEntityHandler entityHandler = RootEntityHandler.forEntityClass((Class)XSHelper.getClass((String)((EntityType)widget.getValue()).getId()));
                if (entityHandler == null || !entityHandler.isAvaibleInConfiguration()) {
                    StandardNotifications.EDITOR_NOT_SUPPORTED.show(null);
                } else {
                    RootEntityActivityHandler.editNew(new DataTransferPackage(new EntityContainer(entityHandler.getEntityClass())));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
        }).show((Region)source);
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return null;
    }
}

