/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.DeliverySelectionPanel;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;

public abstract class BaseDeliveryEntityAddListAction
implements IndexListAction {
    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        DeliverySelectionPanel.DeliverySelectionData data = new DeliverySelectionPanel.DeliverySelectionData();
        DeliverySelectionPanel pane = this.createPanel(context);
        pane.readData(data);
        new Dialog().setTitle(Messages.deliverySelect).setBody((Node)pane, true).addButton(DialogButtonStyle.ACCEPT_CONTINUE, Messages.Dialog_add, () -> {
            pane.writeData(data);
            Notifications.get().submitTask(() -> {
                NestedEntityReference<BookingFile, BaseProduct> product = this.execute(context, data);
                if (product != null) {
                    EventBus.get().publishSync((Event)new EntityModificationEvent((Object)this, new EntityModification(product, EntityModification.ModificationType.CHANGE)));
                    RootEntityEditingService.get().open(product, true, rootEntityPane -> FxUtil.submitToFxThread(() -> ViewWalker.navigateTo((Node)rootEntityPane.getEditor(), (String)product.getNestedEntityUid())), false);
                }
            }, context.getMutex());
        }, (BooleanExpression)pane.validProperty()).addButton(DialogButtonStyle.DECLINE, Messages.Cancel).show((Node)source);
    }

    public abstract String getTaskTitle();

    public abstract NestedEntityReference<BookingFile, BaseProduct> execute(IndexListPane<?, ?> var1, DeliverySelectionPanel.DeliverySelectionData var2) throws Exception;

    public abstract DeliverySelectionPanel createPanel(IndexListPane<?, ?> var1);
}

