/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.Control;

public class BookingFileApplyRulesAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.RULES;
    }

    public double getWeight() {
        return 33.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && context.getEntityHandler().getEntityClass().equals(BookingFile.class);
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode().equals((Object)EditingMode.EDIT);
    }

    public AclQuery getACLQuery(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        if (dtp == null) {
            return null;
        }
        return new AclQuery(StandardRestrictionResourceOperations.EDIT.getId(), ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId(), dtp.getContainer().toReference());
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAsyncAction(context, () -> {
            EntityReference bookingFileReference = context.getData().getContainer().toReference();
            List messages = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).applyRules(ServiceInvocationContext.get(), Collections.singletonList(bookingFileReference));
            FxUtil.submitToFxThread(() -> Notifications.get().showMessages((Collection)messages));
        });
    }

    public String getId() {
        return "booking-file-apply-rules";
    }
}

