/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductsFullPanel;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.entity.actions.BookingFileJoinListAction;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BookingFileJoinDialog;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.exceptions.BookingFileNotFoundException;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.JoinProductsPersistentParameters;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javafx.scene.control.Control;

public class BookingFileJoinAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.BOOKING_FILE_JOIN;
    }

    public double getWeight() {
        return 60.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && context.getEntityHandler().getEntityClass().equals(BookingFile.class);
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode().equals((Object)EditingMode.EDIT);
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        String selectedProductUid = (String)((CompactNavigatorWidget)((BookingFileProductsFullPanel)((BookingFileSpaceController)context.getEditor().getProperties().get((Object)"controller")).getView().getProductsTile().getFullNode()).getContent()).getSelectedView().getProperties().get((Object)"model-uid");
        List<Object> uidsOfSelectedProducts = TextUtil.nonBlank((String)selectedProductUid) ? Collections.singletonList(selectedProductUid) : Collections.emptyList();
        Notifications.get().submitTask(() -> {
            try {
                BookingFileService service = (BookingFileService)RpcServiceManager.get().getService(BookingFileService.class);
                Collection products = service.getJoinProducts(ServiceInvocationContext.get(), Collections.singleton(context.getData().getContainer().toReference()));
                JoinProductsPersistentParameters persistentParameters = BookingFileJoinDialog.loadParameters();
                FxUtil.waitForFxThread(() -> new BookingFileJoinDialog(source, products, uidsOfSelectedProducts, persistentParameters));
            }
            catch (BookingFileNotFoundException ex) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.JoinBookingFiles_BookingFileNotFound, (Object[])new Object[0])});
            }
        }, Messages.Notifications_getting_data);
    }

    public AclQuery getACLQuery(RootEntityPane<?, ?> context) {
        return BookingFileJoinListAction.ACL_QUERY;
    }

    public String getId() {
        return "booking-file-join";
    }
}

