/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.BookingFileJoinDialog;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.exceptions.BookingFileNotFoundException;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicketIndex;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.JoinProductsPersistentParameters;
import com.gridnine.xtrip.common.model.booking.MCOFeesIndex;
import com.gridnine.xtrip.common.model.booking.ProductIndex;
import com.gridnine.xtrip.common.model.booking.agencymemo.AgencyMemoProductIndex;
import com.gridnine.xtrip.common.model.booking.carrental.CarRentalProductIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceAccidentIndex;
import com.gridnine.xtrip.common.model.booking.insurance.InsuranceTouristicIndex;
import com.gridnine.xtrip.common.model.booking.misc.UniversalProductIndex;
import com.gridnine.xtrip.common.model.booking.transfers.TransferIndex;
import com.gridnine.xtrip.common.model.booking.visa.VisaProductIndex;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class BookingFileJoinListAction
implements IndexListAction {
    public static final AclQuery ACL_QUERY = new AclQuery(StandardRestrictionResourceOperations.EDIT.getId(), ModelRestrictionEntityResources.ENTITY_BOOKING_FILE.getId());
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(CommonProductIndex.class, AeroexpressTicketIndex.class, UniversalProductIndex.class, InsuranceAccidentIndex.class, DeliveryIndex.class, MainHotelProductIndex.class, InsuranceTouristicIndex.class, VisaProductIndex.class, AgencyMemoProductIndex.class, TransferIndex.class, CarRentalProductIndex.class, MCOFeesIndex.class, ProductIndex.class, BookingFileIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.BOOKING_FILE_JOIN;
    }

    public double getWeight() {
        return 140.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return ACL_QUERY;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        BookingFileJoinListAction.executeHelper(source, context, alt);
    }

    public static void executeHelper(Control source, IndexListPane<?, ?> context, boolean alt) {
        boolean isBooking = ((EntityIndex)context.getSelectedItems().get(0)).getClass() == BookingFileIndex.class;
        ArrayList uidsOfSelectedProducts = new ArrayList();
        Notifications.get().submitTask(() -> {
            BookingFileService service = (BookingFileService)RpcServiceManager.get().getService(BookingFileService.class);
            Collection tmpProducts = null;
            try {
                tmpProducts = service.getJoinProducts(ServiceInvocationContext.get(), context.getSelectedItems().stream().map(it -> it.getSource()).collect(Collectors.toSet()));
            }
            catch (BookingFileNotFoundException ex) {
                Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.JoinBookingFiles_BookingFileNotFound, (Object[])new Object[0])});
                return;
            }
            Collection products = tmpProducts;
            try {
                if (isBooking) {
                    uidsOfSelectedProducts.addAll(products.stream().map(it -> it.productUid).collect(Collectors.toList()));
                } else {
                    uidsOfSelectedProducts.addAll(context.getSelectedItems().stream().map(EntityIndex::getNavigationKey).collect(Collectors.toList()));
                }
            }
            catch (Exception e) {
                ErrorHandler.handle((Throwable)e);
            }
            JoinProductsPersistentParameters persistentParameters = BookingFileJoinDialog.loadParameters();
            FxUtil.waitForFxThread(() -> new BookingFileJoinDialog(source, products, uidsOfSelectedProducts, persistentParameters));
        }, Messages.Notifications_getting_data);
    }

    public String getId() {
        return "booking-file-list-join";
    }
}

