/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.actions.CorrectionCreateTask;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.CorrectionParametersPane;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CorrectionCreateAction
implements RootEntityAction {
    public String getId() {
        return "correction-create";
    }

    public double getWeight() {
        return 200.6;
    }

    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && BookingFile.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() == EditingMode.EDIT;
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        RootEntityPane.executeAction(context, () -> {
            EntityContainer bookingFileContainer = context.getData().getContainer();
            if (bookingFileContainer != null) {
                this.doAction(source, (EntityContainer<BookingFile>)bookingFileContainer);
            }
        });
    }

    private void doAction(Control source, EntityContainer<BookingFile> bookingFileContainer) {
        Notifications.get().submitTask(() -> {
            List products = BookingHelper.getProducts((BookingFile)((BookingFile)bookingFileContainer.getEntity()));
            CorrectionParametersPane.CorrectionCreateParametersPaneVM parameters = new CorrectionParametersPane.CorrectionCreateParametersPaneVM();
            parameters.setCurrentClient((EntityReference<Organization>)((BookingFile)bookingFileContainer.getEntity()).getCustomerProfile());
            BookingFileService.CorrectionCreateActionParameters params = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).getCorrectionCreateActionParameters(ServiceInvocationContext.get(), bookingFileContainer.toReference());
            parameters.getCurrentPayers().addAll(params.getPayers());
            parameters.getProducts().putAll(products.stream().filter(baseProduct -> ProductHandler.of((BaseProduct)baseProduct).getTicketType(baseProduct) != TicketType.CORRECTION).collect(Collectors.toMap(Function.identity(), v -> Boolean.TRUE)));
            parameters.getRelatedProductsMap().putAll(params.getRelatedProductsMap());
            FxUtil.waitForFxThread(() -> {
                CorrectionParametersPane pane = new CorrectionParametersPane();
                pane.readData(parameters);
                Dialog dialog = new Dialog();
                dialog.setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.correctionCreate).setBody((Node)pane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Create, () -> {
                    pane.writeData(parameters);
                    Notifications.get().enqueueAsyncTask((ClientTask)new CorrectionCreateTask(parameters.getProducts().entrySet().stream().filter(item -> item.getValue() != null && (Boolean)item.getValue() != false).map(Map.Entry::getKey).filter(Objects::nonNull).collect(Collectors.toList()), (EntityReference<BookingFile>)bookingFileContainer.toReference(), parameters.getNewClient(), parameters.getNewPayer()));
                    dialog.close();
                }, (BooleanExpression)pane.validProperty()).setExpandToParent(true).show((Node)source);
            });
        }, Messages.General_Data_loading);
    }
}

