/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.licence.LicenceServerProvider;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CreateContractAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.ADD;
    }

    public String getId() {
        return "entity-contract-create";
    }

    public double getWeight() {
        return -1.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        assert (ett != null);
        return Contract.class.getName().equals(ett.getId());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ComboBoxWidget typeWidget = new ComboBoxWidget(false);
        typeWidget.setNoNulls(true);
        typeWidget.setItemsSupplier(() -> {
            ArrayList<ContractType> list = new ArrayList<ContractType>();
            list.add(ContractType.CLIENT);
            list.add(ContractType.SUBAGENCY);
            list.add(ContractType.VENDOR);
            if (Environment.isPublished(LicenceServerProvider.class)) {
                list.add(ContractType.TECHNICAL_PROVIDER);
            }
            return list;
        });
        typeWidget.valueProperty().set((Object)ContractType.CLIENT);
        new Dialog().setTitle(Messages.Choose_type_of_contract).setBody((Node)typeWidget).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, Messages.Select, () -> RootEntityActivityHandler.editNew(this.createContract((ContractType)typeWidget.valueProperty().get()))).show(context);
    }

    private DataTransferPackage<Contract, Void> createContract(ContractType type) {
        EntityContainer ctr = new EntityContainer(Contract.class);
        ((Contract)ctr.getEntity()).setContractType(type);
        ((Contract)ctr.getEntity()).setNewModel(true);
        return new DataTransferPackage(ctr);
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_CONTRACT.getId());
    }
}

