/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.LightDialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.standard.entity.RootEntityActivityHandler;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistryHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrder;
import com.gridnine.xtrip.common.model.stockcontrol.StockOrderType;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;
import java.util.Arrays;
import java.util.Date;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;

public class CreateStockOrderAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.ADD;
    }

    public String getId() {
        return "entity-stockorder-create";
    }

    public double getWeight() {
        return -1.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        EntityType ett = MetaRegistryHelper.getEntityTypeForIndex((String)context.getIndexType().getName());
        return StockOrder.class.getName().equals(ett.getId());
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ComboBoxWidget widget = new ComboBoxWidget(false);
        widget.setItemsSupplier(() -> Arrays.asList(StockOrderType.TRANSFER, StockOrderType.VENDOR));
        widget.setNoNulls(true);
        widget.setSortItems(false);
        widget.valueProperty().set((Object)StockOrderType.TRANSFER);
        widget.guessPrefWidth();
        new LightDialog().setTitle(Messages.Choose_type_of_order).setBody((Node)widget).setActionCaption(Messages.Select).setActionHandler(() -> RootEntityActivityHandler.editNew(this.createContract((StockOrderType)widget.getValue()))).show((Region)source);
    }

    private DataTransferPackage<StockOrder, Void> createContract(StockOrderType type) {
        EntityContainer ctr = new EntityContainer(StockOrder.class);
        ((StockOrder)ctr.getEntity()).setType(type);
        ((StockOrder)ctr.getEntity()).setCreated(new Date());
        ((StockOrder)ctr.getEntity()).setRegistrationDate(new Date());
        return new DataTransferPackage(ctr);
    }

    public AclQuery getACLQuery(IndexListPane<?, ?> context) {
        return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_STOCK_ORDER.getId());
    }
}

