/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.dialogs.DialogButtonStyle;
import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.entity.editor.EditingMode;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.tasks.dialog.DebitOrderDetachParametersPane;
import com.gridnine.xtrip.common.fx.rpc.FinanceDocumentsService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.IBusFinanceContextKeys;
import com.gridnine.xtrip.common.model.finance.DebitBankTransferOrder;
import com.gridnine.xtrip.common.model.finance.FinanceDocument;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.ChangeData;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanExpression;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class DebitOrderDetachAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 32.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && DebitBankTransferOrder.class.isAssignableFrom(context.getEntityHandler().getEntityClass());
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        return context.getMode() == EditingMode.EDIT && context.getData() != null && !((DebitBankTransferOrder)context.getData().getContainer().getEntity()).getFinanceDocuments().isEmpty();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        List financeDocumentReferences = ((DebitBankTransferOrder)context.getData().getContainer().getEntity()).getFinanceDocuments();
        Notifications.get().submitTask(() -> {
            Map groupedDocuments = ((FinanceDocumentsService)RpcServiceManager.get().getService(FinanceDocumentsService.class)).getGroupedDocuments(ServiceInvocationContext.get(), financeDocumentReferences);
            FxUtil.waitForFxThread(() -> {
                DebitOrderDetachParametersPane parametersPane = new DebitOrderDetachParametersPane();
                parametersPane.readData(groupedDocuments);
                new Dialog().setTitle(com.gridnine.xtrip.client.fx.standard.l10n.Messages.Debit_order_detach_from_selected).setBody((Node)parametersPane).addButton(DialogButtonStyle.DECLINE).addButton(DialogButtonStyle.ACCEPT_REGULAR, com.gridnine.xtrip.client.fx.standard.l10n.Messages.Detach, () -> {
                    List<EntityReference<FinanceDocument>> selectedFinanceDocuments = parametersPane.getSelectedFinanceDocuments();
                    Notifications.get().submitTask(() -> {
                        HashMap<String, Object> contextMap = new HashMap<String, Object>();
                        contextMap.put(IBusFinanceContextKeys.DEBIT_ORDER_REFERENCE.name(), context.getData().getContainer().toReference());
                        contextMap.put(IBusFinanceContextKeys.FINANCE_DOCUMENT_REFERENCES.name(), selectedFinanceDocuments);
                        Set<String> returnKeys = Collections.singleton(IBusStandardContextKeys.CHANGED_DATA.name());
                        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "debit-orders:detach", contextMap, returnKeys);
                        ChangeData data = (ChangeData)ibusResult.get(IBusStandardContextKeys.CHANGED_DATA.name());
                        if (data != null) {
                            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)data.getChanged().stream().map(item -> new EntityModification(item, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
                        }
                        Notifications.get().showMessages(new Message[]{MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.Debit_order_detached, (Object[])new Object[0])});
                    }, Messages.General_Data_loading);
                }, (BooleanExpression)parametersPane.validProperty()).setExpandToParent(true).show((Node)source);
            });
        }, context.getMutex());
    }

    public String getId() {
        return "detach-from-invoice";
    }
}

