/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.helper.DeliveryFXHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.BookingFileService;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.delivery.DeliveryIndex;
import com.gridnine.xtrip.common.model.helpers.MessageBuilder;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.TemplateDocumentIndex;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.scene.control.Control;

public class DeliveryProductCreateDeliveryRouteListListAction
implements IndexListAction {
    private static final Collection<Class<?>> ALLOWED_TYPES = Arrays.asList(CommonProductIndex.class, DeliveryIndex.class);

    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.CREATE_DOCUMENT;
    }

    public double getWeight() {
        return 100.0;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return ALLOWED_TYPES.contains(context.getIndexType());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isEnabled(IndexListPane<?, ?> context) {
        if (context.getSelectedItems().isEmpty()) return false;
        if (!context.getSelectedItems().stream().filter(item -> item instanceof CommonProductIndex).map(CommonProductIndex.class::cast).allMatch(item -> item.getProductType() == null || item.getProductType() == ProductType.DELIVERY)) return false;
        return true;
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        ArrayList productIndexList = new ArrayList();
        ArrayList deliveryIndexList = new ArrayList();
        context.getSelectedItems().forEach(item -> {
            if (item instanceof CommonProductIndex) {
                productIndexList.add((CommonProductIndex)item);
            }
            if (item instanceof DeliveryIndex) {
                deliveryIndexList.add((DeliveryIndex)item);
            }
        });
        Notifications.get().submitTask(() -> {
            Set searchPairs;
            List<TemplateDocumentIndex> data = DeliveryFXHelper.getCourierRouteListTemplates();
            if (data.isEmpty()) {
                Notifications.get().showMessages(new Message[]{MessageBuilder.error((String)Messages.deliveryRouteList_templateNotFound).build()});
                return;
            }
            if (deliveryIndexList.isEmpty()) {
                SearchQuery query = new SearchQuery();
                query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])productIndexList.stream().map(item -> SearchCriterion.eq((String)"navigationKey", (Object)item.getNavigationKey())).toArray(SearchCriterion[]::new))));
                deliveryIndexList.addAll(((EntityService)RpcServiceManager.get().getService(EntityService.class)).search(ServiceInvocationContext.get(), DeliveryIndex.class, query));
            }
            if ((searchPairs = deliveryIndexList.stream().filter(delivery -> delivery.getCourier() != null && delivery.getDeliveryDate() != null).map(deliveryIndex -> {
                MiscUtil.Pair searchPair = new MiscUtil.Pair();
                searchPair.setFirst((Object)deliveryIndex.getCourier());
                searchPair.setSecond((Object)MiscUtil.clearTime((Date)deliveryIndex.getDeliveryDate()));
                return searchPair;
            }).collect(Collectors.toSet())).isEmpty()) {
                Notifications.get().showMessages(new Message[]{MessageBuilder.error((String)Messages.deliveryRouteList_invalidDelivery).build()});
                return;
            }
            for (MiscUtil.Pair searchPair : searchPairs) {
                List<DeliveryIndex> deliveryIndices = DeliveryFXHelper.searchSimilarlyDeliveries((EntityReference<Person>)((EntityReference)searchPair.getFirst()), (Date)searchPair.getSecond());
                BookingFileService.DeliveryRPCResult result = ((BookingFileService)RpcServiceManager.get().getService(BookingFileService.class)).renderDeliveryRouteList(ServiceInvocationContext.get(), deliveryIndices, data.get(0).getSource());
                if (!result.getResultMessageList().isEmpty()) {
                    Notifications.get().showMessages((Collection)result.getResultMessageList());
                }
                if (result.getResultObject() == null) continue;
                FxUtil.submitToFxThread(() -> RootEntityEditingService.get().open(result.getResultObject(), false));
            }
        }, Messages.Notifications_getting_data);
    }

    public String getId() {
        return "create-delivery-route-list";
    }
}

