/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.RootEntityHandler;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.kb.KeyBindingAction;
import com.gridnine.xtrip.client.fx.core.kb.StandardKeyBindingActions;
import com.gridnine.xtrip.client.fx.core.lib.ViewWalker;
import com.gridnine.xtrip.client.fx.core.service.RootEntityEditingService;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.standard.helpers.EntityEditorHelper;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Referenceable;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.system.BillingTransactionIndex;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class EditEntityAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.EDIT;
    }

    public String getId() {
        return "entity-edit";
    }

    public double getWeight() {
        return 1.0;
    }

    public KeyBindingAction getKeyBindingAction() {
        return StandardKeyBindingActions.EDIT;
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        Class indexType = context.getIndexType();
        return indexType != BillingTransactionIndex.class && !ArchivedProductIndex.class.isAssignableFrom(indexType);
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        if (selectedItems.isEmpty()) {
            return;
        }
        ArrayList<EntityReference> unsupported = new ArrayList<EntityReference>();
        boolean bgLoad = false;
        for (EntityIndex idx : selectedItems) {
            EntityReference sourceRef;
            EntityReference entityReference = sourceRef = idx instanceof Referenceable ? ((Referenceable)idx).getRef() : idx.getSource();
            if (RootEntityHandler.forEntityClass((Class)sourceRef.getType()) == null) {
                unsupported.add(sourceRef);
                continue;
            }
            String navigationKey = idx.getNavigationKey();
            if (TextUtil.isBlank((String)navigationKey)) {
                RootEntityEditingService.get().open(sourceRef, true, null, bgLoad);
            } else {
                RootEntityEditingService.get().open(sourceRef, true, rep -> FxUtil.submitToFxThread(() -> ViewWalker.navigateTo((Node)rep.getEditor(), (String)navigationKey)), bgLoad);
            }
            bgLoad = true;
        }
        if (!unsupported.isEmpty()) {
            if (alt) {
                for (EntityReference ref : unsupported) {
                    EntityEditorHelper.open(ref, null);
                }
                return;
            }
            if (selectedItems.size() == unsupported.size()) {
                Notifications.get().showFlashNotification(Messages.Editing_documents_is_not_supported, null);
            } else {
                Notifications.get().showFlashNotification(Messages.Editing_some_documents_is_not_supported, null);
            }
        }
    }
}

