/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.standard.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.dialogs.Dialog;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListAction;
import com.gridnine.xtrip.client.fx.core.entity.list.IndexListPane;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.l10n.Messages;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.rpc.ModelService;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import java.util.List;
import javafx.scene.control.Control;

public class ExportAgainBookingFileEntityListAction
implements IndexListAction {
    public ActionIcon getIcon(IndexListPane<?, ?> context) {
        return StandardActionIcons.REPEAT;
    }

    public double getWeight() {
        return 51.0;
    }

    public boolean isEnabled(IndexListPane<?, ?> context) {
        return !context.getSelectedItems().isEmpty();
    }

    public boolean isAvailable(IndexListPane<?, ?> context) {
        return context.getIndexType().equals(BookingFileIndex.class);
    }

    public void execute(Control source, IndexListPane<?, ?> context, boolean alt) {
        List selectedItems = context.getSelectedItems();
        Dialog.confirm(context, (String)Messages.Reexport_for_selected_orders, () -> Notifications.get().submitTask(() -> {
            ModelService service = (ModelService)RpcServiceManager.get().getService(ModelService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            for (BookingFileIndex idx : selectedItems) {
                service.createExportDocument(sic, idx.getSource());
            }
        }, Messages.Orders_exporting));
    }

    public String getId() {
        return "booking-file-export-againList";
    }
}

